/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.suncode.pwfl.core.type.TypeBase;
import com.suncode.pwfl.core.type.support.JsonTypeBase;
import java.util.Date;
import org.joda.time.LocalDateTime;

public class DateTimeType
extends JsonTypeBase<LocalDateTime> {
    public static final DateTimeType INSTANCE = new DateTimeType();

    private DateTimeType() {
        super(LocalDateTime.class);
        this.aliasType(Date.class, new TypeBase.Convert<Date, LocalDateTime>(){

            @Override
            public Date fromBase(LocalDateTime value) {
                return value.toDate();
            }

            @Override
            public LocalDateTime toBase(Date value) {
                return LocalDateTime.fromDateFields((Date)value);
            }
        });
    }

    @Override
    public String name() {
        return "datetime";
    }

    @Override
    public String translationKey() {
        return "Data_i_czas";
    }

    @Override
    protected JsonNode serializeNonNullValue(LocalDateTime value) {
        return LongNode.valueOf((long)value.toDateTime().getMillis());
    }

    @Override
    protected LocalDateTime deserializeNonEmptyNode(JsonNode json) {
        return new LocalDateTime(json.asLong());
    }
}

