/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.function;

import com.suncode.pwfl.core.function.Function;
import com.suncode.pwfl.core.function.FunctionOverride;
import com.suncode.pwfl.core.type.Type;
import java.util.List;
import org.springframework.util.Assert;

public class FunctionCall {
    private final FunctionOverride override;
    private final Object[] args;

    public FunctionCall(Function fn, Object ... args) {
        this(FunctionCall.valid(fn.getOverride(args), "There is no matching function " + fn + " override for args: " + args), args);
    }

    public FunctionCall(Function fn, List<Type<?>> parameterTypes, Object ... args) {
        this(FunctionCall.valid(fn.getOverride(parameterTypes.toArray(new Type[parameterTypes.size()])), "There is no matching function " + fn + " override for parameter types: " + parameterTypes), args);
    }

    public FunctionCall(FunctionOverride override, Object ... args) {
        Assert.notNull((Object)override, (String)"Function override must not be null");
        this.override = override;
        this.args = args;
    }

    private static FunctionOverride valid(FunctionOverride override, String message) {
        if (override == null) {
            throw new IllegalArgumentException(message);
        }
        return override;
    }

    public String getName() {
        return this.getFunction().getName();
    }

    public Function getFunction() {
        return this.override.getFunction();
    }

    public FunctionOverride getOverride() {
        return this.override;
    }

    public Type<?> getReturnType() {
        return this.override.getReturnType();
    }

    public Object[] getArgs() {
        return (Object[])this.args.clone();
    }

    public <T> T call() {
        return this.override.call(this.args);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.getReturnType()).append(" ").append(this.override.getName()).append("(");
        if (this.args.length > 0) {
            for (Object arg : this.args) {
                sb.append(arg).append(", ");
            }
            sb.setLength(sb.length() - 2);
        }
        return sb.append(")").toString();
    }
}

