/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.component.declaration;

import com.google.common.collect.Maps;
import com.suncode.pwfl.workflow.component.declaration.ConditionDeclaration;
import com.suncode.pwfl.workflow.component.declaration.ParameterDeclaration;
import java.util.Map;
import org.springframework.util.Assert;

public class ComponentDeclaration {
    private String id;
    private ConditionDeclaration condition;
    private Map<String, ParameterDeclaration> parameters = Maps.newLinkedHashMap();

    public ComponentDeclaration(String id) {
        Assert.hasText((String)id);
        this.id = id;
    }

    public ComponentDeclaration(String id, ConditionDeclaration condition) {
        this(id);
        this.condition = condition;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ConditionDeclaration getCondition() {
        return this.condition;
    }

    public void setCondition(ConditionDeclaration condition) {
        this.condition = condition;
    }

    public Map<String, ParameterDeclaration> getParameters() {
        return this.parameters;
    }

    public ParameterDeclaration getParameter(String name) {
        return this.parameters.get(name);
    }

    public void setParameters(Map<String, ParameterDeclaration> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(String name, ParameterDeclaration parameter) {
        this.parameters.put(name, parameter);
    }

    public void changeParameter(String name, ParameterDeclaration parameter) {
        if (this.parameters.get(name) != null) {
            this.parameters.put(name, parameter);
        }
    }
}

