/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.component;

import com.google.common.collect.Maps;
import com.suncode.pwfl.component.ComponentDefinition;
import com.suncode.pwfl.workflow.component.ContextVariable;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

public class ContextVariables {
    private final Map<String, Holder> values = Maps.newHashMap();

    public ContextVariables(ComponentDefinition component) {
        this(component.getContextVariables());
    }

    public ContextVariables(List<ContextVariable<?>> contextVariables) {
        for (ContextVariable<?> variable : contextVariables) {
            this.values.put(variable.getId(), new Holder(variable));
        }
    }

    public <T> T get(String id) {
        return (T)this.holder(id).getValue();
    }

    public <T> void set(String id, T value) {
        this.holder(id).setValue(value);
    }

    public <T> ContextVariable<T> getContextVariable(String id) {
        return this.holder(id).variable;
    }

    public boolean isContextVariable(String id) {
        return id.startsWith("context:");
    }

    private Holder holder(String id) {
        Holder holder = this.values.get(this.normalizeId(id));
        if (holder == null) {
            throw new IllegalArgumentException("There is not context variable with id: " + id);
        }
        return holder;
    }

    private String normalizeId(String id) {
        if (!id.startsWith("context:")) {
            return "context:" + id;
        }
        return id;
    }

    private static class Holder {
        private final ContextVariable<?> variable;
        private Object value;

        private Holder(ContextVariable<?> variable) {
            Assert.notNull(variable);
            this.variable = variable;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            if (!this.variable.getType().isInstance(value)) {
                throw new IllegalArgumentException("Object [" + value + "] is not an instance of " + this.variable.getType());
            }
            this.value = value;
        }
    }
}

