/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.configuration;

import com.plusmpm.security.TextCipher;
import com.suncode.pwfl.administration.configuration.Category;
import com.suncode.pwfl.administration.configuration.ComboValue;
import com.suncode.pwfl.administration.configuration.ParameterType;
import com.suncode.pwfl.administration.configuration.exception.DecryptingException;
import com.suncode.pwfl.administration.configuration.exception.EncryptingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="pm_systemparameter")
@SequenceGenerator(name="pm_systemparameter_seq", sequenceName="pm_systemparameter_seq")
public class SystemParameter {
    private static final Logger log = LoggerFactory.getLogger(SystemParameter.class);
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_systemparameter_seq")
    private Long id;
    @Column(name="parameterkey")
    private String key;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @JoinColumn(name="categoryid", nullable=false)
    private Category category;
    @Enumerated(value=EnumType.STRING)
    private ParameterType parameterType;
    private String valueString;
    private Long valueLong;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="systemParameter")
    private List<ComboValue> comboValues = new LinkedList<ComboValue>();
    private Boolean valueBool;
    private Date valueDate;
    private Double valueDouble;
    private boolean removable = true;

    public SystemParameter() {
    }

    public SystemParameter(Category category, ParameterType type, String key) {
        this();
        this.category = category;
        this.parameterType = type;
        this.key = key;
        if (type == ParameterType.BOOLEAN) {
            this.valueBool = false;
        }
    }

    @Transient
    public void setValue(Object value) throws RuntimeException {
        if (value == null) {
            this.setNull();
            return;
        }
        switch (this.parameterType) {
            case BOOLEAN: {
                this.valueBool = Boolean.parseBoolean(value.toString());
                break;
            }
            case COMBOBOX: {
                this.valueString = value.toString();
                break;
            }
            case DATE: {
                try {
                    if (value instanceof Date) {
                        this.valueDate = (Date)value;
                        break;
                    }
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    this.valueDate = format.parse(value.toString());
                    break;
                }
                catch (ParseException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            case LONG: {
                this.valueLong = Long.parseLong(value.toString());
                break;
            }
            case DOUBLE: {
                this.valueDouble = Double.parseDouble(value.toString());
                break;
            }
            case TEXT: {
                this.valueString = value.toString();
                break;
            }
            case PASSWORD: {
                if (!StringUtils.isNotEmpty((CharSequence)value.toString())) break;
                try {
                    this.valueString = TextCipher.encrypt(value.toString());
                    break;
                }
                catch (Exception e) {
                    throw new EncryptingException(e);
                }
            }
            default: {
                throw new IllegalArgumentException("Unsupported ParamterType " + (Object)((Object)this.parameterType));
            }
        }
    }

    @Transient
    private void setNull() {
        this.valueBool = this.parameterType == ParameterType.BOOLEAN ? Boolean.valueOf(false) : null;
        this.valueString = null;
        this.valueDate = null;
        this.valueLong = null;
        this.valueDouble = null;
    }

    @Transient
    public Object getValue() {
        switch (this.parameterType) {
            case BOOLEAN: {
                return this.valueBool;
            }
            case COMBOBOX: {
                return this.valueString;
            }
            case DATE: {
                if (this.valueDate != null) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    return format.format(this.valueDate);
                }
                return null;
            }
            case LONG: {
                return this.valueLong;
            }
            case DOUBLE: {
                return this.valueDouble;
            }
            case TEXT: {
                return this.valueString;
            }
            case PASSWORD: {
                if (this.valueString != null) {
                    if (StringUtils.isNotEmpty((CharSequence)this.valueString)) {
                        try {
                            return TextCipher.decrypt(this.valueString);
                        }
                        catch (Exception e) {
                            throw new DecryptingException(e);
                        }
                    }
                    return "";
                }
                return null;
            }
        }
        throw new RuntimeException("Unknow System Parameter type " + (Object)((Object)this.parameterType));
    }

    @Transient
    public Boolean isNull() {
        try {
            return this.getValue() == null;
        }
        catch (DecryptingException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return true;
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public Category getCategory() {
        return this.category;
    }

    public ParameterType getParameterType() {
        return this.parameterType;
    }

    public String getValueString() {
        return this.valueString;
    }

    public Long getValueLong() {
        return this.valueLong;
    }

    public List<ComboValue> getComboValues() {
        return this.comboValues;
    }

    public Boolean getValueBool() {
        return this.valueBool;
    }

    public Date getValueDate() {
        return this.valueDate;
    }

    public Double getValueDouble() {
        return this.valueDouble;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public void setParameterType(ParameterType parameterType) {
        this.parameterType = parameterType;
    }

    public void setValueString(String valueString) {
        this.valueString = valueString;
    }

    public void setValueLong(Long valueLong) {
        this.valueLong = valueLong;
    }

    public void setComboValues(List<ComboValue> comboValues) {
        this.comboValues = comboValues;
    }

    public void setValueBool(Boolean valueBool) {
        this.valueBool = valueBool;
    }

    public void setValueDate(Date valueDate) {
        this.valueDate = valueDate;
    }

    public void setValueDouble(Double valueDouble) {
        this.valueDouble = valueDouble;
    }

    public void setRemovable(boolean removable) {
        this.removable = removable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemParameter)) {
            return false;
        }
        SystemParameter other = (SystemParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        Category this$category = this.getCategory();
        Category other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        ParameterType this$parameterType = this.getParameterType();
        ParameterType other$parameterType = other.getParameterType();
        if (this$parameterType == null ? other$parameterType != null : !((Object)((Object)this$parameterType)).equals((Object)other$parameterType)) {
            return false;
        }
        String this$valueString = this.getValueString();
        String other$valueString = other.getValueString();
        if (this$valueString == null ? other$valueString != null : !this$valueString.equals(other$valueString)) {
            return false;
        }
        Long this$valueLong = this.getValueLong();
        Long other$valueLong = other.getValueLong();
        if (this$valueLong == null ? other$valueLong != null : !((Object)this$valueLong).equals(other$valueLong)) {
            return false;
        }
        List<ComboValue> this$comboValues = this.getComboValues();
        List<ComboValue> other$comboValues = other.getComboValues();
        if (this$comboValues == null ? other$comboValues != null : !((Object)this$comboValues).equals(other$comboValues)) {
            return false;
        }
        Boolean this$valueBool = this.getValueBool();
        Boolean other$valueBool = other.getValueBool();
        if (this$valueBool == null ? other$valueBool != null : !((Object)this$valueBool).equals(other$valueBool)) {
            return false;
        }
        Date this$valueDate = this.getValueDate();
        Date other$valueDate = other.getValueDate();
        if (this$valueDate == null ? other$valueDate != null : !((Object)this$valueDate).equals(other$valueDate)) {
            return false;
        }
        Double this$valueDouble = this.getValueDouble();
        Double other$valueDouble = other.getValueDouble();
        if (this$valueDouble == null ? other$valueDouble != null : !((Object)this$valueDouble).equals(other$valueDouble)) {
            return false;
        }
        return this.isRemovable() == other.isRemovable();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SystemParameter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        Category $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        ParameterType $parameterType = this.getParameterType();
        result = result * 59 + ($parameterType == null ? 43 : ((Object)((Object)$parameterType)).hashCode());
        String $valueString = this.getValueString();
        result = result * 59 + ($valueString == null ? 43 : $valueString.hashCode());
        Long $valueLong = this.getValueLong();
        result = result * 59 + ($valueLong == null ? 43 : ((Object)$valueLong).hashCode());
        List<ComboValue> $comboValues = this.getComboValues();
        result = result * 59 + ($comboValues == null ? 43 : ((Object)$comboValues).hashCode());
        Boolean $valueBool = this.getValueBool();
        result = result * 59 + ($valueBool == null ? 43 : ((Object)$valueBool).hashCode());
        Date $valueDate = this.getValueDate();
        result = result * 59 + ($valueDate == null ? 43 : ((Object)$valueDate).hashCode());
        Double $valueDouble = this.getValueDouble();
        result = result * 59 + ($valueDouble == null ? 43 : ((Object)$valueDouble).hashCode());
        result = result * 59 + (this.isRemovable() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SystemParameter(id=" + this.getId() + ", key=" + this.getKey() + ", category=" + this.getCategory() + ", parameterType=" + (Object)((Object)this.getParameterType()) + ", valueString=" + this.getValueString() + ", valueLong=" + this.getValueLong() + ", comboValues=" + this.getComboValues() + ", valueBool=" + this.getValueBool() + ", valueDate=" + this.getValueDate() + ", valueDouble=" + this.getValueDouble() + ", removable=" + this.isRemovable() + ")";
    }
}

