/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.form.validator.error;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.component.WorkflowComponentRegistry;
import com.suncode.pwfl.workflow.form.validator.annotation.ValidatorsScript;
import com.suncode.pwfl.workflow.form.validator.error.Confirmation;
import com.suncode.pwfl.workflow.form.validator.error.ValidationError;
import com.suncode.pwfl.workflow.form.validator.error.VariableSetVariableValidationError;
import com.suncode.pwfl.workflow.form.validator.error.VariableValidationError;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ValidationErrors {
    private final Multimap<String, ValidationError> errors = HashMultimap.create();
    private final List<Confirmation> confirmations = Lists.newArrayList();
    private String currentValidator = null;
    private Set<String> invokedCallbackValidators = Sets.newHashSet();

    public void setCurrentValidator(String currentValidator) {
        this.currentValidator = currentValidator;
    }

    public void removeCurrentValidator() {
        this.currentValidator = null;
    }

    public void add(String error) {
        this.errors.put((Object)this.currentValidator, (Object)new ValidationError(error));
    }

    public void add(ValidationError error) {
        this.errors.put((Object)this.currentValidator, (Object)error);
    }

    public void add(String error, String variableId) {
        this.errors.put((Object)this.currentValidator, (Object)new VariableValidationError(variableId, error));
    }

    public void add(String error, String variableId, int rowIndex) {
        this.errors.put((Object)this.currentValidator, (Object)new VariableSetVariableValidationError(variableId, rowIndex, error));
    }

    public void addConfirmation(String message, String title) {
        this.addConfirmation(new Confirmation(message, title));
    }

    public void addConfirmation(Confirmation confirmation) {
        this.confirmations.add(confirmation);
    }

    public List<ValidationError> getErrors() {
        return ImmutableList.copyOf((Collection)this.errors.values());
    }

    public Map<String, Collection<ValidationError>> getErrorsMap() {
        return this.errors.asMap();
    }

    public List<ValidationError> getErrors(String validatorId) {
        return ImmutableList.copyOf((Collection)this.errors.get((Object)validatorId));
    }

    public List<Confirmation> getConfirmations() {
        return ImmutableList.copyOf(this.confirmations);
    }

    public boolean areEmpty() {
        return this.errors.isEmpty();
    }

    public void invokeCallback() {
        if (!ValidationErrors.isCallbackValidator(this.currentValidator).booleanValue()) {
            throw new RuntimeException("Cannot invoke callback for validator without script");
        }
        this.invokedCallbackValidators.add(this.currentValidator);
    }

    private static Boolean isCallbackValidator(String validatorId) {
        ValidatorsScript script;
        WorkflowComponentRegistry componentRegistry = SpringContext.getBean(WorkflowComponentRegistry.class);
        Class<?> source = componentRegistry.getValidatorSourceClass(validatorId);
        if (source != null && (script = source.getAnnotation(ValidatorsScript.class)) != null) {
            return true;
        }
        return false;
    }

    public Boolean hasInvokedCallback(String validatorId) {
        return this.invokedCallbackValidators.contains(validatorId);
    }

    public List<String> getInvokedCallbackValidators() {
        return ImmutableList.copyOf(this.invokedCallbackValidators);
    }
}

