/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.experimental;

import com.suncode.pwfl.experimental.Experimental;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ExperimentalConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ExperimentalConfiguration.class);
    private static final String HOME_DIRECTORY = "plusworkflow.home";
    private static final String EXPERIMENTAL_CONFIG_RELATIVE_PATH = "config/experimental.properties";
    private static Experimental EXPERIMENTAL_INSTANCE;

    @Bean
    public Experimental experimental() throws IOException {
        return Objects.requireNonNull(EXPERIMENTAL_INSTANCE);
    }

    public static void initialize() {
        if (EXPERIMENTAL_INSTANCE != null) {
            throw new IllegalStateException("Experimental is already initialized");
        }
        File file = Paths.get(System.getProperty(HOME_DIRECTORY), EXPERIMENTAL_CONFIG_RELATIVE_PATH).toFile();
        Properties properties = new Properties();
        try (FileInputStream defaultFileStream = new FileInputStream(file);){
            properties.load(defaultFileStream);
            log.info("Experimental features file was successfully loaded. Properties in file: " + properties.size());
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> log.info("Feature flag: " + key + " has value: " + value)));
        }
        catch (FileNotFoundException e) {
            log.info("Cannot find file. Skipping");
        }
        EXPERIMENTAL_INSTANCE = new Experimental(properties);
    }

    public static Experimental getExperimentalInstance() {
        return Objects.requireNonNull(EXPERIMENTAL_INSTANCE);
    }
}

