/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import com.suncode.pwfl.administration.archive.DisplayedIndex;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.IndexPattern;
import com.suncode.pwfl.archive.IndexType;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Type;

@Entity
@Table(name="pm_indecies")
@SequenceGenerator(name="pm_indecies_id_seq", sequenceName="pm_indecies_id_seq")
public class DocumentClassIndex {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_indecies_id_seq")
    private Long id;
    @Column(name="indexname")
    @NonNull
    private String name;
    @Column(name="indexdescription")
    private String description;
    @Column(name="indextype")
    @Type(type="com.suncode.pwfl.archive.IndexTypeEnum")
    @NonNull
    private IndexType type;
    @Column(name="indexvalues")
    private String values;
    @Column(name="indexorderid")
    private Long orderId;
    @JoinColumn(name="docclassid")
    @ManyToOne(fetch=FetchType.LAZY)
    private DocumentClass documentClass;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="index", cascade={CascadeType.ALL})
    private List<DisplayedIndex> displayedIndexes;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="index", cascade={CascadeType.ALL})
    private List<IndexPattern> patterns;

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this).append("id", (Object)this.id).append("name", (Object)this.name).append("type", (Object)this.type.toString()).append("values", (Object)(StringUtils.isNotEmpty((String)this.values) ? this.values.replace("\n", ",") : "")).append("order", (Object)this.orderId);
        if (this.patterns != null && Hibernate.isInitialized(this.patterns)) {
            builder.append("pattern", (Object)this.patterns.stream().map(pattern -> pattern.getPattern() + "->" + pattern.getReplacement()).collect(Collectors.joining(",")));
        }
        return builder.toString();
    }

    public static DocumentClassIndexBuilder builder() {
        return new DocumentClassIndexBuilder();
    }

    public Long getId() {
        return this.id;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @NonNull
    public IndexType getType() {
        return this.type;
    }

    public String getValues() {
        return this.values;
    }

    public Long getOrderId() {
        return this.orderId;
    }

    public DocumentClass getDocumentClass() {
        return this.documentClass;
    }

    public List<DisplayedIndex> getDisplayedIndexes() {
        return this.displayedIndexes;
    }

    public List<IndexPattern> getPatterns() {
        return this.patterns;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(@NonNull IndexType type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.type = type;
    }

    public void setValues(String values) {
        this.values = values;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public void setDocumentClass(DocumentClass documentClass) {
        this.documentClass = documentClass;
    }

    public void setDisplayedIndexes(List<DisplayedIndex> displayedIndexes) {
        this.displayedIndexes = displayedIndexes;
    }

    public void setPatterns(List<IndexPattern> patterns) {
        this.patterns = patterns;
    }

    public DocumentClassIndex() {
    }

    @ConstructorProperties(value={"id", "name", "description", "type", "values", "orderId", "documentClass", "displayedIndexes", "patterns"})
    public DocumentClassIndex(Long id, @NonNull String name, String description, @NonNull IndexType type, String values, Long orderId, DocumentClass documentClass, List<DisplayedIndex> displayedIndexes, List<IndexPattern> patterns) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.id = id;
        this.name = name;
        this.description = description;
        this.type = type;
        this.values = values;
        this.orderId = orderId;
        this.documentClass = documentClass;
        this.displayedIndexes = displayedIndexes;
        this.patterns = patterns;
    }

    @ConstructorProperties(value={"name", "type"})
    public DocumentClassIndex(@NonNull String name, @NonNull IndexType type) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.name = name;
        this.type = type;
    }

    public static class DocumentClassIndexBuilder {
        private Long id;
        private String name;
        private String description;
        private IndexType type;
        private String values;
        private Long orderId;
        private DocumentClass documentClass;
        private List<DisplayedIndex> displayedIndexes;
        private List<IndexPattern> patterns;

        DocumentClassIndexBuilder() {
        }

        public DocumentClassIndexBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public DocumentClassIndexBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DocumentClassIndexBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DocumentClassIndexBuilder type(IndexType type) {
            this.type = type;
            return this;
        }

        public DocumentClassIndexBuilder values(String values) {
            this.values = values;
            return this;
        }

        public DocumentClassIndexBuilder orderId(Long orderId) {
            this.orderId = orderId;
            return this;
        }

        public DocumentClassIndexBuilder documentClass(DocumentClass documentClass) {
            this.documentClass = documentClass;
            return this;
        }

        public DocumentClassIndexBuilder displayedIndexes(List<DisplayedIndex> displayedIndexes) {
            this.displayedIndexes = displayedIndexes;
            return this;
        }

        public DocumentClassIndexBuilder patterns(List<IndexPattern> patterns) {
            this.patterns = patterns;
            return this;
        }

        public DocumentClassIndex build() {
            return new DocumentClassIndex(this.id, this.name, this.description, this.type, this.values, this.orderId, this.documentClass, this.displayedIndexes, this.patterns);
        }

        public String toString() {
            return "DocumentClassIndex.DocumentClassIndexBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", type=" + (Object)((Object)this.type) + ", values=" + this.values + ", orderId=" + this.orderId + ", documentClass=" + this.documentClass + ", displayedIndexes=" + this.displayedIndexes + ", patterns=" + this.patterns + ")";
        }
    }
}

