/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.search;

import com.suncode.pwfl.search.PaginationException;
import com.suncode.pwfl.search.Sorter;
import org.apache.commons.lang.StringUtils;

public class Pagination {
    private Sorter sorter;
    private Integer start;
    private Integer limit;

    private Pagination() {
    }

    private Pagination(Sorter sorter, Integer start, Integer limit) {
        this.sorter = sorter;
        this.start = start;
        this.limit = limit;
    }

    public static Pagination create(Sorter sorter, Integer start, Integer limit) {
        if (sorter == null) {
            throw new PaginationException("Sorter cannot be null.");
        }
        if (StringUtils.isBlank((String)sorter.getProperty())) {
            throw new PaginationException("Sort property cannot be null or empty.");
        }
        Pagination pagination = new Pagination(sorter, start, limit);
        return pagination;
    }

    public Sorter getSorter() {
        return this.sorter;
    }

    public void setSorter(Sorter sorter) {
        this.sorter = sorter;
    }

    public Integer getStart() {
        return this.start;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }
}

