/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.suncode.pwfl.core.data.Record;
import com.suncode.pwfl.core.data.TableStore;
import com.suncode.pwfl.core.type.BasicTypes;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.TypeBase;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.core.type.support.JsonSerializable;
import com.suncode.pwfl.core.type.support.JsonTypeBase;
import com.suncode.pwfl.util.Maps;
import com.suncode.pwfl.util.Streams;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TableStoreType
extends JsonTypeBase<TableStore> {
    static final TableStoreType INSTANCE = new TableStoreType();

    public TableStoreType() {
        super(TableStore.class, TableStore.empty());
        this.converter(String.class, new TypeBase.Convert<String, TableStore>(){

            @Override
            public String fromBase(TableStore value) {
                return TableStoreType.this.convertToJsonString(value);
            }

            @Override
            public TableStore toBase(String value) {
                return (TableStore)TableStoreType.this.convertFromJsonString(value);
            }
        });
    }

    @Override
    public String name() {
        return "tablestore";
    }

    @Override
    public String translationKey() {
        return "TableStore";
    }

    @Override
    public TableStore convert(String value) {
        return (TableStore)this.convertFromJsonString(value);
    }

    @Override
    protected JsonNode serializeNonNullValue(TableStore tableStore) {
        ArrayNode data = JsonNodeFactory.instance.arrayNode();
        tableStore.getData().forEach(record -> {
            ObjectNode node = JsonNodeFactory.instance.objectNode();
            record.getFields().forEach((field, value) -> node.set(field, this.serialize(value)));
            data.add((JsonNode)node);
        });
        ObjectNode schema = JsonNodeFactory.instance.objectNode();
        tableStore.getVariableType().forEach((field, type) -> schema.put(field, type.name().toLowerCase()));
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        result.set("variableType", (JsonNode)schema);
        result.set("data", (JsonNode)data);
        return result;
    }

    @Override
    protected TableStore deserializeNonEmptyNode(JsonNode json) {
        Map<String, BasicTypes> schema = Streams.asStream(json.get("variableType").fields()).map(Maps.entryV(typeNode -> BasicTypes.valueOf(typeNode.asText().toUpperCase()))).collect(Maps.toMap());
        List<Record> data = Streams.asStream(json.get("data").iterator()).map(recordNode -> {
            Record.RecordBuilder record = Record.builder();
            recordNode.fields().forEachRemaining(Maps.consumeEntries((fieldName, valueNode) -> record.field((String)fieldName, this.deserialize((JsonNode)valueNode, (BasicTypes)((Object)((Object)((Object)schema.get(fieldName))))))));
            return record.build();
        }).collect(Collectors.toList());
        return new TableStore(schema, data);
    }

    private <T> JsonNode serialize(T value) {
        if (value == null) {
            return NullNode.instance;
        }
        Type<T> type = Types.typeOf(value);
        if (type instanceof JsonSerializable) {
            return ((JsonSerializable)((Object)type)).serializeJson(value);
        }
        return TextNode.valueOf((String)type.readAs(value, String.class));
    }

    private Object deserialize(JsonNode valueNode, BasicTypes basicType) {
        Type<?> type = basicType.getType();
        if (type instanceof JsonSerializable) {
            return ((JsonSerializable)((Object)type)).deserializeJson(valueNode);
        }
        return type.convert(valueNode.textValue());
    }
}

