/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.util;

import com.suncode.pwfl.administration.configuration.SystemParameterService;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.administration.substitution.SubstitutionService;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.UserSettingsService;
import com.suncode.pwfl.archive.ArchiveStorageService;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.DocumentTemplateService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.database.sequence.SequenceService;
import com.suncode.pwfl.support.CustomService;
import com.suncode.pwfl.transaction.SharkTransactionManager;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.activity.ActivityDocumentService;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.transfer.TransferActivityService;
import com.suncode.pwfl.workflow.assignment.AssignmentService;
import com.suncode.pwfl.workflow.form.FormService;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.process.ProcessService;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ServiceFactory {
    private static ApplicationContext ctx;

    public static UserService getUserService() {
        return (UserService)ctx.getBean("userService");
    }

    public static ActivityService getActivityService() {
        SharkTransactionManager tm = TransactionManagerFactory.getSharkTransactionManager();
        if (tm.isSharkTransactionActive()) {
            return (ActivityService)ctx.getBean("sharkActivityService");
        }
        return (ActivityService)ctx.getBean("activityService");
    }

    public static ActivityService getSharkActivityService() {
        return (ActivityService)ctx.getBean("sharkActivityService");
    }

    public static StructureService getStructureService() {
        return (StructureService)ctx.getBean(StructureService.class);
    }

    public static ProcessService getProcessService() {
        SharkTransactionManager tm = TransactionManagerFactory.getSharkTransactionManager();
        if (tm.isSharkTransactionActive()) {
            return (ProcessService)ctx.getBean("sharkProcessService");
        }
        return (ProcessService)ctx.getBean("processService");
    }

    public static ArchiveStorageService getArchiveStorageService() {
        return (ArchiveStorageService)ctx.getBean(ArchiveStorageService.class);
    }

    public static DocumentClassService getDocumentClassService() {
        return (DocumentClassService)ctx.getBean("documentClassService");
    }

    public static FileService getFileService() {
        return (FileService)ctx.getBean(FileService.class);
    }

    public static UserSettingsService getUserSettingsService() {
        return (UserSettingsService)ctx.getBean("userSettingsService");
    }

    public static CommentService getCommentService() {
        return (CommentService)ctx.getBean("commentService");
    }

    public static FormService getFormService() {
        return (FormService)ctx.getBean("formService");
    }

    public static <E, P> CustomService<E, P> getCustomService(Class<E> clazz, Class<P> pk) {
        CustomService s = new CustomService(clazz);
        s.setSessionFactory((SessionFactory)SpringContext.getInstance().getBean("sessionFactory"));
        s = (CustomService)SpringContext.getInstance().getBeanFactory().initializeBean(s, "customService");
        return s;
    }

    public static DocumentTemplateService getDocumentTemplateService() {
        return (DocumentTemplateService)ctx.getBean("documentTemplateService");
    }

    public static DocumentService getDocumentService() {
        return (DocumentService)ctx.getBean(DocumentService.class);
    }

    public static DocumentClassActionService getDocumentClassActionService() {
        return (DocumentClassActionService)ctx.getBean(DocumentClassActionService.class);
    }

    public static RoleService getRoleService() {
        return (RoleService)ctx.getBean(RoleService.class);
    }

    public static SequenceService getSequenceService() {
        return (SequenceService)ctx.getBean(SequenceService.class);
    }

    public static SubstitutionService getSubstitutionService() {
        return (SubstitutionService)ctx.getBean(SubstitutionService.class);
    }

    public static SystemParameterService getSystemParameterService() {
        return (SystemParameterService)ctx.getBean(SystemParameterService.class);
    }

    public static ActivityDocumentService getActivityDocumentService() {
        return (ActivityDocumentService)ctx.getBean(ActivityDocumentService.class);
    }

    public static AssignmentService getAssignmentService() {
        return (AssignmentService)ctx.getBean(AssignmentService.class);
    }

    public static TransferActivityService getTransferActivityService() {
        return (TransferActivityService)ctx.getBean(TransferActivityService.class);
    }

    @Autowired
    public void setContext(ApplicationContext ctx) {
        ServiceFactory.ctx = ctx;
    }
}

