/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.transaction.support;

import com.suncode.pwfl.database.DataSourceFactory;
import com.suncode.pwfl.transaction.support.SharkTransactionCallback;
import com.suncode.pwfl.transaction.support.SharkTransactionCallbackWithoutResult;
import com.suncode.pwfl.transaction.support.SharkTransactionTemplate;
import java.sql.Connection;
import org.enhydra.shark.api.SharkTransaction;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate4.HibernateTransactionManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

@Component
public class TransactionWrapper {
    private static TransactionWrapper instance;
    @Autowired
    private HibernateTransactionManager hibernateTransactionManager;

    private TransactionWrapper() {
        Assert.isNull((Object)instance);
        instance = this;
    }

    public static TransactionWrapper get() {
        return instance;
    }

    public void doInHibernateTransaction(final HibernateRunnable runnable) {
        TransactionTemplate transaction = new TransactionTemplate((PlatformTransactionManager)this.hibernateTransactionManager);
        transaction.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                runnable.run(TransactionWrapper.this.hibernateTransactionManager.getSessionFactory().getCurrentSession());
            }
        });
    }

    public <T> T doInHibernateTransaction(HibernateCallable<T> callable) {
        TransactionTemplate transaction = new TransactionTemplate((PlatformTransactionManager)this.hibernateTransactionManager);
        return (T)transaction.execute(status -> callable.call(this.hibernateTransactionManager.getSessionFactory().getCurrentSession()));
    }

    public void doInNewHibernateTransaction(HibernateRunnable runnable) {
        this.doInNewHibernateTransaction((Session session) -> {
            runnable.run(session);
            return null;
        });
    }

    public <T> T doInNewHibernateTransaction(HibernateCallable<T> callable) {
        TransactionTemplate transaction = new TransactionTemplate((PlatformTransactionManager)this.hibernateTransactionManager, (TransactionDefinition)new DefaultTransactionDefinition(3));
        return (T)transaction.execute(status -> callable.call(this.hibernateTransactionManager.getSessionFactory().getCurrentSession()));
    }

    public void doInSharkTransaction(final SharkRunnable runnable) {
        SharkTransactionTemplate transaction = new SharkTransactionTemplate();
        transaction.execute(new SharkTransactionCallbackWithoutResult(){

            @Override
            public void doInSharkTransactionWithoutResult(SharkTransaction transaction, TransactionStatus status) {
                runnable.run(transaction);
            }
        });
    }

    public void doInSharkTransaction(final SharkRunnable runnable, int propagationBehaviour) {
        SharkTransactionTemplate transaction = new SharkTransactionTemplate();
        transaction.setPropagationBehavior(propagationBehaviour);
        transaction.execute(new SharkTransactionCallbackWithoutResult(){

            @Override
            public void doInSharkTransactionWithoutResult(SharkTransaction transaction, TransactionStatus status) {
                runnable.run(transaction);
            }
        });
    }

    public <T> T doInSharkTransaction(final SharkCallable<T> callable) {
        SharkTransactionTemplate transaction = new SharkTransactionTemplate();
        return transaction.execute(new SharkTransactionCallback<T>(){

            @Override
            public T doInSharkTransaction(SharkTransaction transaction, TransactionStatus status) {
                return callable.call(transaction);
            }
        });
    }

    public void doInJdbcConnection(JdbcRunnable runnable) {
        try (Connection connection = DataSourceFactory.getDataSource().getConnection();){
            runnable.run(connection);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T doInJdbcConnection(JdbcCallable<T> callable) {
        try (Connection connection = DataSourceFactory.getDataSource().getConnection();){
            T t = callable.call(connection);
            return t;
        }
    }

    @FunctionalInterface
    public static interface JdbcCallable<T> {
        public T call(Connection var1);
    }

    @FunctionalInterface
    public static interface JdbcRunnable {
        public void run(Connection var1);
    }

    @FunctionalInterface
    public static interface SharkCallable<T> {
        public T call(SharkTransaction var1);
    }

    @FunctionalInterface
    public static interface SharkRunnable {
        public void run(SharkTransaction var1);
    }

    @FunctionalInterface
    public static interface HibernateCallable<T> {
        public T call(Session var1);
    }

    @FunctionalInterface
    public static interface HibernateRunnable {
        public void run(Session var1);
    }
}

