/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.util;

import com.suncode.pwfl.audit.util.AuditCategories;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.translation.TranslationSupport;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.TranslatorScope;
import com.suncode.pwfl.translation.Translators;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.context.i18n.LocaleContextHolder;

public enum AuditTypes {
    AUDIT_ALL,
    AUDIT_LOG_IN,
    AUDIT_LOG_IN_API,
    AUDIT_LOG_IN_UNIVERSAL_PASSWORD,
    AUDIT_LOG_IN_API_UNIVERSAL_PASSWORD,
    AUDIT_LOG_OUT,
    AUDIT_SEARCH_ACTIVITIES,
    AUDIT_OPEN_ACTIVITY,
    AUDIT_SAVE_ACTIVITY,
    AUDIT_ACCEPT_ACTIVITY,
    AUDIT_SEARCH_PROCESSES,
    AUDIT_SEARCH_DOCCLASS,
    AUDIT_SEARCH_LINK,
    AUDIT_ADD_USER,
    AUDIT_IMPORT_USER_FROM_LDAP,
    AUDIT_UPDATE_USER,
    AUDIT_DELETE_USER,
    AUDIT_SEARCH_USER,
    AUDIT_ADD_GROUP,
    AUDIT_UPDATE_GROUP,
    AUDIT_DELETE_GROUP,
    AUDIT_ADD_SYSTEM_PROTECTION,
    AUDIT_DELETE_SYSTEM_PROTECTION,
    AUDIT_ADD_DELEGATION,
    AUDIT_ADD_DELEGATION_BY_USER,
    AUDIT_DELETE_DELEGATION,
    AUDIT_DELETE_DELEGATION_BY_USER,
    AUDIT_ADD_POSITION,
    AUDIT_UPDATE_POSITION,
    AUDIT_DELETE_POSITION,
    AUDIT_SEARCH_POSITION,
    AUDIT_ADD_ORG_UNIT,
    AUDIT_UPDATE_ORG_UNIT,
    AUDIT_DELETE_ORG_UNIT,
    AUDIT_SEARCH_ORG_UNIT,
    AUDIT_ADD_DOCCLASS,
    AUDIT_UPDATE_DOCCLASS,
    AUDIT_DELETE_DOCCLASS,
    AUDIT_ADD_LINK,
    AUDIT_UPDATE_LINK,
    AUDIT_DELETE_LINK,
    AUDIT_ADD_DIRECTORY,
    AUDIT_DELETE_DIRECTORY,
    AUDIT_ADD_DEVICE,
    AUDIT_DELETE_DEVICE,
    AUDIT_ADD_LDAP_SERVER,
    AUDIT_UPDATE_LDAP_SERVER,
    AUDIT_DELETE_LDAP_SERVER,
    AUDIT_STATS,
    AUDIT_UPLOAD_FILE_FROM_PROCESS,
    AUDIT_UPLOAD_FILE_FROM_ARCHIVE,
    AUDIT_CHECKOUT_FILE_FROM_PROCESS,
    AUDIT_CHECKOUT_FILE_FROM_ARCHIVE,
    AUDIT_UPDATE_USER_SETTINGS,
    AUDIT_CREATE_PROCESS,
    AUDIT_ADD_ROLE_TO_POSITION,
    AUDIT_DELETE_ROLE_FROM_POSITION,
    AUDIT_ADD_NOTIFICATION,
    AUDIT_EDIT_NOTIFICATION,
    AUDIT_DELETE_NOTIFICATION,
    AUDIT_ADD_DOCUMENT_TEMPLATE,
    AUDIT_DELETE_DOCUMENT_TEMPLATE,
    AUDIT_ADD_DOC_CLASS_INDEX,
    AUDIT_UPDATE_DOC_CLASS_INDEX,
    AUDIT_DELETE_DOC_CLASS_INDEX,
    AUDIT_ENABLE_USER_NOTIFICATIONS,
    AUDIT_DISABLE_USER_NOTIFICATIONS,
    AUDIT_ADD_DOC_CLASS_ACTION,
    AUDIT_EDIT_DOC_CLASS_ACTION,
    AUDIT_DELETE_DOC_CLASS_ACTION,
    AUDIT_ADD_PROCESS_PROTECTION,
    AUDIT_DELETE_PROCESS_PROTECTION,
    AUDIT_INSTALL_MODULE,
    AUDIT_UNINSTALL_MODULE,
    AUDIT_ADD_USER_TO_GROUP,
    AUDIT_DELETE_USER_FROM_GROUP,
    AUDIT_ADD_COMMENT_TO_ACTIVITY,
    AUDIT_DELETE_COMMENT_FROM_ACTIVITY,
    AUDIT_ADD_GROUP_TO_USER,
    AUDIT_DELETE_DOCUMENT_FROM_PROCESS,
    AUDIT_PROCESS_DETAILS,
    AUDIT_ACTIVITY_DETAILS,
    AUDIT_CHECK_IN_DOCUMENT_FROM_ACTIVITY,
    AUDIT_CHECK_IN_DOCUMENT_FROM_ARCHIVE,
    AUDIT_DELETE_DOCUMENT_FROM_ARCHIVE,
    AUDIT_DELETE_SEARCHED_DOCUMENTS,
    AUDIT_DEACTIVATE_USER,
    AUDIT_ACTIVATE_USER,
    AUDIT_EDIT_DEACTIVATED_USER,
    AUDIT_EDIT_DOCUMENT_INDEXES,
    AUDIT_DELETE_PROCESS,
    AUDIT_ABORT_PROCESS,
    AUDIT_SUSPEND_ACTIVITY,
    AUDIT_RESUME_ACTIVITY,
    AUDIT_ABORT_ACTIVITY,
    AUDIT_SAVE_VIEW,
    AUDIT_ACCEPT_MANY_ACTIVITIES,
    AUDIT_ADD_DOCUMENT_VIEW,
    AUDIT_EDIT_DOCUMENT_VIEW,
    AUDIT_DELETE_DOCUMENT_VIEW,
    AUDIT_RUN_VIEW,
    AUDIT_SAVE_PROCESS_SETTINGS,
    AUDIT_LOAD_LICENSE,
    AUDIT_ADD_DOC_CLASS_PROTECTION,
    AUDIT_EDIT_DOC_CLASS_PROTECTION,
    AUDIT_DELETE_DOC_CLASS_PROTECTION,
    AUDIT_ADD_LINK_INDEX,
    AUDIT_EDIT_LINK_INDEX,
    AUDIT_DELETE_LINK_INDEX,
    AUDIT_ADD_LINK_CONNECTION,
    AUDIT_DELETE_LINK_CONNECTION,
    AUDIT_ADD_LINK_PROTECTION,
    AUDIT_EDIT_LINK_PROTECTION,
    AUDIT_DELETE_LINK_PROTECTION,
    AUDIT_CHANGE_PASSWORD,
    AUDIT_EDIT_USER_NOTIFICATIONS,
    AUDIT_DELETE_USER_NOTIFICATIONS,
    AUDIT_LOAD_PACKAGE,
    AUDIT_UPDATE_PACKAGE,
    AUDIT_CLOSE_PACKAGE,
    AUDIT_CLEAR_PACKAGE,
    AUDIT_ADD_VIEW_REPORT,
    AUDIT_ADD_SQL_QUERY_REPORT,
    AUDIT_ADD_JASPER_REPORT,
    AUDIT_EDIT_JASPER_REPORT,
    AUDIT_RUN_VIEW_REPORT,
    AUDIT_RUN_SQL_QUERY_REPORT,
    AUDIT_RUN_JASPER_REPORT,
    AUDIT_RUN_SAVED_REPORT,
    AUDIT_FILTER_REPORT,
    AUDIT_ADD_MODULE_RIGHT,
    AUDIT_DELETE_MODULE_RIGHT,
    AUDIT_ADD_SCHEDULED_TASK,
    AUDIT_UPDATE_SCHEDULED_TASK,
    AUDIT_DELETE_SCHEDULED_TASK,
    AUDIT_RUN_SCHEDULED_TASK,
    AUDIT_MANUAL_RUN_SCHEDULED_TASK,
    AUDIT_STOP_SCHEDULED_TASK,
    AUDIT_INSTALL_PLUGIN_LICENSE,
    AUDIT_INSTALL_PLUGIN,
    AUDIT_UPDATE_PLUGIN,
    AUDIT_START_PLUGIN,
    AUDIT_STOP_PLUGIN,
    AUDIT_DELETE_PLUGIN,
    AUDIT_AUTO_LOG_IN,
    AUDIT_AUTO_LOG_OUT,
    AUDIT_SYSTEM_PARAMETER_CREATED,
    AUDIT_SYSTEM_PARAMETER_REMOVED,
    AUDIT_SYSTEM_PARAMETER_CHANGED,
    AUDIT_PASSWORD_PROFILE_CREATED,
    AUDIT_PASSWORD_PROFILE_CHANGED,
    AUDIT_PASSWORD_PROFILE_REMOVED,
    AUDIT_PASSWORD_PROFILE_PRIORITY_CHANGED,
    AUDIT_PASSWORD_PROFILES_ASSIGNED,
    AUDIT_USER_REQUEST_PASSWORD_RECOVERY,
    AUDIT_USER_CHANGE_PASSWORD_RECOVERY,
    AUDIT_SYSTEM_STARTED,
    AUDIT_SYSTEM_STOPPED,
    AUDIT_SEARCH_EXCEL_EXPORT,
    AUDIT_UPDATE_USER_SETTINGS_GLOBAL,
    AUDIT_SEND_EMAIL,
    AUDIT_AUTOMATIC_LOGOUT,
    AUDIT_DELETE_PROCESSES,
    AUDIT_LDAP_CHANGE_PASSWORD,
    AUDIT_IMPORT_USERS_FROM_GROUP_TO_GROUP,
    AUDIT_ABORT_PROCESSES,
    AUDIT_ADMIN_PASSWORD_CHANGING_ON_STARTUP,
    AUDIT_SECURITY,
    AUDIT_BLOCK_USER_BY_ADMIN,
    AUDIT_UNLOCK_USER_BY_ADMIN,
    AUDIT_ASSIGN_POSITION_TO_USER,
    AUDIT_DETACH_POSITION,
    AUDIT_CERTIFICATES_ADDED,
    AUDIT_CERTIFICATES_RENAMED,
    AUDIT_CERTIFICATES_REMOVED,
    AUDIT_CONFIG_TRANSFER_EXPORT,
    AUDIT_CONFIG_TRANSFER_GET_FROM_BASE,
    AUDIT_CONFIG_TRANSFER_GET_FROM_FILE,
    AUDIT_CONFIG_TRANSFER_IMPORT,
    AUDIT_ADMIN_ADD_DOC_CLASS_ASSOCIATION,
    AUDIT_ADMIN_DELETE_DOC_CLASS_ASSOCIATION,
    AUDIT_ADMIN_UPDATE_DOC_CLASS_ASSOCIATION,
    AUDIT_SELF_PASSWORD_ASSIGN;


    public static HashMap<String, String> getIdNamePairs() {
        HashMap<String, String> translations = new HashMap<String, String>();
        Locale locale = LocaleContextHolder.getLocale();
        for (AuditTypes auditType : AuditTypes.values()) {
            if (auditType.equals((Object)AUDIT_ALL)) continue;
            String auditTypeId = auditType.toString();
            translations.put(auditTypeId, MessageHelper.getOptionalMessage((String)auditTypeId, (Locale)locale, (Object[])new Object[0]));
        }
        return translations;
    }

    public static String getTranslatedAuditType(String typeId) {
        Locale locale = LocaleContextHolder.getLocale();
        for (AuditTypes value : AuditTypes.values()) {
            if (value.toString().compareTo(typeId) != 0) continue;
            return MessageHelper.getOptionalMessage((String)typeId, (Locale)locale, (Object[])new Object[0]);
        }
        List<Translator> translators = Translators.getAll(TranslatorScope.SERVER);
        return TranslationSupport.getMessage(typeId, translators);
    }

    public static AuditTypes getByName(String name) {
        return AuditTypes.valueOf(name);
    }

    public static List<AuditTypes> getByCategory(AuditCategories category) {
        if (category != null) {
            return Stream.of(AuditTypes.values()).filter(type -> category.toString().equalsIgnoreCase(AuditCategories.getCategoryNameForAudit(type))).collect(Collectors.toList());
        }
        return new ArrayList<AuditTypes>();
    }
}

