/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.plusmpm.util.documents.handlers.DocumentHandlerTypes;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.util.exception.ServiceException;
import java.beans.ConstructorProperties;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="pm_actions")
@SequenceGenerator(name="pm_actions_id_seq", sequenceName="pm_actions_id_seq")
public class DocumentClassAction {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_actions_id_seq")
    private Long id;
    @Column(name="actionname")
    private String name;
    @Column(name="actionsource")
    private String source;
    @Column(name="invokefornewversion")
    private Boolean invokeForNewVersion;
    @Column(name="actiontype")
    private String type;
    @Column(name="actionvalue")
    private String value;
    @Column(name="actionvalue2")
    private String value2;
    @JoinColumn(name="docclassid")
    @ManyToOne(fetch=FetchType.LAZY)
    private DocumentClass documentClass;

    public void setSource(String source) {
        this.source = source;
    }

    @Transient
    public void setSource(DocumentEventTypes type) {
        this.source = this.getSourceName(type);
    }

    public void setType(String type) {
        this.type = type;
    }

    @Transient
    public void setType(DocumentHandlerTypes type) {
        if (DocumentHandlerTypes.CREATE_NEW_PROCESS.equals((Object)type)) {
            this.type = "createNewProcess";
        } else if (DocumentHandlerTypes.ADD_DOC_TO_PROCESS.equals((Object)type)) {
            this.type = "addDocToProcess";
        } else if (DocumentHandlerTypes.DELETE_DOCUMENT.equals((Object)type)) {
            this.type = "deleteDocument";
        } else if (DocumentHandlerTypes.REWRITE_IDX_FROM_PROCESS_TO_DOC.equals((Object)type)) {
            this.type = "rewriteIdxFromProcessToDoc";
        } else if (DocumentHandlerTypes.REWRITE_IDX_FROM_DOC_TO_PROCESS.equals((Object)type)) {
            this.type = "rewriteIdxFromDocToProcess";
        } else if (DocumentHandlerTypes.RUN_SCRIPT.equals((Object)type)) {
            this.type = "runScript";
        } else {
            throw new ServiceException("Nieprawid\u0142owa nazwa typu akcji: [" + (Object)((Object)type) + "]");
        }
    }

    @Transient
    public DocumentHandlerTypes getHandlerType() {
        if (this.type.equals("createNewProcess")) {
            return DocumentHandlerTypes.CREATE_NEW_PROCESS;
        }
        if (this.type.equals("addDocToProcess")) {
            return DocumentHandlerTypes.ADD_DOC_TO_PROCESS;
        }
        if (this.type.equals("deleteDocument")) {
            return DocumentHandlerTypes.DELETE_DOCUMENT;
        }
        if (this.type.equals("rewriteIdxFromProcessToDoc")) {
            return DocumentHandlerTypes.REWRITE_IDX_FROM_PROCESS_TO_DOC;
        }
        if (this.type.equals("rewriteIdxFromDocToProcess")) {
            return DocumentHandlerTypes.REWRITE_IDX_FROM_DOC_TO_PROCESS;
        }
        if (this.type.equals("runScript")) {
            return DocumentHandlerTypes.RUN_SCRIPT;
        }
        throw new ServiceException("Nieprawid\u0142owa nazwa typu akcji: [" + this.type + "]");
    }

    @Transient
    public String getSourceName(DocumentEventTypes eventType) {
        switch (eventType) {
            case NEW_DOCUMENT_IN_ARCHIVE: {
                return "newDocumentInArchive";
            }
            case NEW_DOCUMENT_IN_PROCESS: {
                return "newDocumentInProcess";
            }
            case CHANGE_PROCESS_DATA: {
                return "changeProcessData";
            }
            case DELETE_DOCUMENT_FROM_PROCESS: {
                return "dettachDocument";
            }
            case DELETE_DOCUMENT_FROM_ARCHIVE: {
                return "deleteDocumentFromArchive";
            }
            case DOCUMENT_EXPIRED: {
                return "expireDocument";
            }
            case ADD_DOCUMENT_TO_PROCESS: {
                return "attachDocument";
            }
        }
        throw new IllegalArgumentException("Nie obs\u0142ugiwany typ zdarzenia");
    }

    public static DocumentClassActionBuilder builder() {
        return new DocumentClassActionBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSource() {
        return this.source;
    }

    public Boolean getInvokeForNewVersion() {
        return this.invokeForNewVersion;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String getValue2() {
        return this.value2;
    }

    public DocumentClass getDocumentClass() {
        return this.documentClass;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInvokeForNewVersion(Boolean invokeForNewVersion) {
        this.invokeForNewVersion = invokeForNewVersion;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValue2(String value2) {
        this.value2 = value2;
    }

    public void setDocumentClass(DocumentClass documentClass) {
        this.documentClass = documentClass;
    }

    public DocumentClassAction() {
    }

    @ConstructorProperties(value={"id", "name", "source", "invokeForNewVersion", "type", "value", "value2", "documentClass"})
    public DocumentClassAction(Long id, String name, String source, Boolean invokeForNewVersion, String type, String value, String value2, DocumentClass documentClass) {
        this.id = id;
        this.name = name;
        this.source = source;
        this.invokeForNewVersion = invokeForNewVersion;
        this.type = type;
        this.value = value;
        this.value2 = value2;
        this.documentClass = documentClass;
    }

    public static class DocumentClassActionBuilder {
        private Long id;
        private String name;
        private String source;
        private Boolean invokeForNewVersion;
        private String type;
        private String value;
        private String value2;
        private DocumentClass documentClass;

        DocumentClassActionBuilder() {
        }

        public DocumentClassActionBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public DocumentClassActionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DocumentClassActionBuilder source(String source) {
            this.source = source;
            return this;
        }

        public DocumentClassActionBuilder invokeForNewVersion(Boolean invokeForNewVersion) {
            this.invokeForNewVersion = invokeForNewVersion;
            return this;
        }

        public DocumentClassActionBuilder type(String type) {
            this.type = type;
            return this;
        }

        public DocumentClassActionBuilder value(String value) {
            this.value = value;
            return this;
        }

        public DocumentClassActionBuilder value2(String value2) {
            this.value2 = value2;
            return this;
        }

        public DocumentClassActionBuilder documentClass(DocumentClass documentClass) {
            this.documentClass = documentClass;
            return this;
        }

        public DocumentClassAction build() {
            return new DocumentClassAction(this.id, this.name, this.source, this.invokeForNewVersion, this.type, this.value, this.value2, this.documentClass);
        }

        public String toString() {
            return "DocumentClassAction.DocumentClassActionBuilder(id=" + this.id + ", name=" + this.name + ", source=" + this.source + ", invokeForNewVersion=" + this.invokeForNewVersion + ", type=" + this.type + ", value=" + this.value + ", value2=" + this.value2 + ", documentClass=" + this.documentClass + ")";
        }
    }
}

