/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.user.UserGroup;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;

public class User
implements Serializable {
    public static final String JOIN_GROUPS = "groups";
    public static final String JOIN_POSITIONS = "positions";
    public static final String JOIN_OU = "positions.organizationalUnit";
    @NonNull
    private String userName;
    private Long objectId;
    private String firstName;
    private String lastName;
    @JsonIgnore
    @NonNull
    private String password;
    private String email;
    private Boolean active;
    private String number;
    private Set<Position> positions = new HashSet<Position>();
    private Set<UserGroup> groups = new HashSet<UserGroup>();
    private boolean waitingForPasswordAssign;

    void addGroup(UserGroup userGroup) {
        this.groups.add(userGroup);
    }

    void addGroup(String groupName) {
        UserGroup ug = new UserGroup(groupName);
        this.groups.add(ug);
    }

    void setUserName(String userName) {
        if (StringUtils.isBlank((String)userName)) {
            throw new IllegalArgumentException("Login u\u017cytkownika nie mo\u017ce by\u0107 pusty");
        }
        this.userName = userName;
    }

    public String getFullName() {
        return StringUtils.trimToEmpty((String)(StringUtils.trimToEmpty((String)this.getFirstName()) + " " + StringUtils.trimToEmpty((String)this.getLastName())));
    }

    public Boolean isActive() {
        return this.active;
    }

    public String toString() {
        return this.userName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }

    public User() {
    }

    @ConstructorProperties(value={"userName", "password"})
    public User(@NonNull String userName, @NonNull String password) {
        if (userName == null) {
            throw new NullPointerException("userName");
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        this.userName = userName;
        this.password = password;
    }

    @NonNull
    public String getUserName() {
        return this.userName;
    }

    public Long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(Long objectId) {
        this.objectId = objectId;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @NonNull
    public String getPassword() {
        return this.password;
    }

    public void setPassword(@NonNull String password) {
        if (password == null) {
            throw new NullPointerException("password");
        }
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Set<Position> getPositions() {
        return this.positions;
    }

    public void setPositions(Set<Position> positions) {
        this.positions = positions;
    }

    public Set<UserGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<UserGroup> groups) {
        this.groups = groups;
    }

    public boolean isWaitingForPasswordAssign() {
        return this.waitingForPasswordAssign;
    }

    public void setWaitingForPasswordAssign(boolean waitingForPasswordAssign) {
        this.waitingForPasswordAssign = waitingForPasswordAssign;
    }
}

