/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.type;

import com.suncode.pwfl.core.type.EvaluableType;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import org.springframework.util.Assert;

public class TypedValue<T> {
    private final T value;
    private final Type<T> type;

    public TypedValue(T value) {
        this(value, Types.typeOf(value));
    }

    public TypedValue(T value, Type<T> type) {
        Assert.notNull(type);
        Assert.isTrue((value == null || type.isInstance(value) ? 1 : 0) != 0);
        this.value = value;
        this.type = type;
    }

    public static <T> TypedValue<T> nullValue(Type<T> type) {
        return new TypedValue<Object>(null, type);
    }

    public T get() {
        return this.value;
    }

    public final Type<T> getType() {
        return this.type;
    }

    public boolean isInstanceOf(Type<?> target) {
        T value = this.get();
        if (value == null) {
            return true;
        }
        if (this.type.equals(target)) {
            return true;
        }
        return this.getEvaluableType().equals(target);
    }

    public Type<?> getEvaluableType() {
        T value = this.get();
        if (value != null && this.type instanceof EvaluableType) {
            EvaluableType evaluableType = (EvaluableType)this.type;
            return evaluableType.evaluatedType(value);
        }
        return this.type;
    }

    public <V> V getEvaluatedValue() {
        return (V)this.getEvaluatedValue(this.getEvaluableType().javaType());
    }

    public <V> V getEvaluatedValue(Class<V> targetClass) {
        T value = this.get();
        if (value == null) {
            return null;
        }
        if (!this.type.isInstance(targetClass) && this.type instanceof EvaluableType) {
            EvaluableType evaluableType = (EvaluableType)this.type;
            Object evalValue = evaluableType.evaluate(value);
            Type<?> evalType = evaluableType.evaluatedType(value);
            return evalType.readAs(evalValue, targetClass);
        }
        return this.type.readAs(value, targetClass);
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

