/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.configuration.dto.common.right;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigurationDtoRight {
    private boolean group;
    private String level;
    private String resourceId;
    private Integer type;

    public boolean levelContainsDocClass() {
        return ConfigurationDtoRight.levelContainsSomeDocClass(this.level);
    }

    public static boolean levelContainsSomeDocClass(String level) {
        return level.contains("system.archive.docclasses.");
    }

    public static boolean levelContainsDocClass(String level, long docClassId) {
        return level.equals("system.archive.docclasses." + docClassId) || level.contains("system.archive.docclasses." + docClassId + ".");
    }

    public boolean levelContainsLink() {
        return ConfigurationDtoRight.levelContainsSomeLink(this.level);
    }

    public static boolean levelContainsSomeLink(String level) {
        return level.contains("system.archive.links.");
    }

    public static boolean levelContainsLink(String level, long linkId) {
        return level.equals("system.archive.links." + linkId) || level.contains("system.archive.links." + linkId + ".");
    }

    public static boolean levelContainsSomeProcess(String level) {
        String exp = "system\\.workflow\\.processes\\..*\\.";
        Pattern p = Pattern.compile(exp);
        Matcher m = p.matcher(level);
        return m.find();
    }

    public static boolean levelContainsProcess(String level, String processDefId) {
        return ConfigurationDtoRight.levelContainsSomeProcess(level) && level.contains(processDefId);
    }

    public static boolean isSystemRight(String level) {
        return !ConfigurationDtoRight.levelContainsSomeDocClass(level) && !ConfigurationDtoRight.levelContainsSomeLink(level) && !ConfigurationDtoRight.levelContainsSomeProcess(level);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationDtoRight that = (ConfigurationDtoRight)o;
        return this.group == that.group && Objects.equals(this.level, that.level) && Objects.equals(this.resourceId, that.resourceId) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.level, this.resourceId, this.type);
    }

    public boolean isGroup() {
        return this.group;
    }

    public String getLevel() {
        return this.level;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public Integer getType() {
        return this.type;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public void setType(Integer type) {
        this.type = type;
    }
}

