/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.experimental;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Experimental {
    private static final Logger log = LoggerFactory.getLogger(Experimental.class);
    private static final String HOME_DIRECTORY = "plusworkflow.home";
    private static final String EXPERIMENTAL_CONFIG_RELATIVE_PATH = "config/experimental.properties";
    private static Properties properties = new Properties();

    private static void loadDefault() {
        File experimentalFile = Paths.get(System.getProperty(HOME_DIRECTORY), EXPERIMENTAL_CONFIG_RELATIVE_PATH).toFile();
        try (FileInputStream defaultFileStream = new FileInputStream(experimentalFile);){
            Experimental.load(defaultFileStream);
        }
        catch (FileNotFoundException e) {
            log.debug("Cannot find experimental flags file. Skipping");
        }
    }

    static void load(InputStream stream) throws IOException {
        properties.load(stream);
    }

    public static boolean hasFeature(String feature) {
        String featureValue = properties.getProperty(feature);
        return featureValue != null && Boolean.parseBoolean(featureValue.trim());
    }

    static {
        Experimental.loadDefault();
    }
}

