/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.configuration.audit;

import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ConfigurationTransferAudit {
    private final Map<ElementType, Set<String>> result = new HashMap<ElementType, Set<String>>();

    public void addElement(ElementType type) {
        this.result.put(type, null);
    }

    public void addElement(ElementType type, String value) {
        this.result.computeIfAbsent(type, v -> new HashSet()).add(value);
    }

    public Map<String, Object> getParameters() {
        return this.result.entrySet().stream().collect(Collectors.toMap(e -> ((ElementType)((Object)((Object)e.getKey()))).toString(), e -> {
            if (e.getValue() != null) {
                return String.join((CharSequence)", ", (Iterable)e.getValue());
            }
            return MessageHelper.getMessage((String)"Zaimportowane");
        }));
    }

    public static enum ElementType {
        GROUPS,
        USERS,
        DOMAINS,
        POSITIONS,
        ORG_UNITS,
        DEVICES,
        DIRECTORIES,
        DOC_CLASSES,
        LINKS,
        PROCESSES_NOTIFICATIONS,
        PROCESSES_TEMPLATES,
        PROCESSES_SETTINGS,
        PROCESSES_DOCUMENT_VIEWS,
        PROCESSES_REPLACEMENTS,
        PROCESSES_RIGHTS,
        SUBSTITUTIONS,
        RIGHTS,
        VIEWS_PRIVATE,
        VIEWS_PUBLIC;

    }
}

