/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.scheduledtask;

import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinition;
import com.suncode.pwfl.component.ParameterDefinition;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.component.ContextVariables;
import com.suncode.pwfl.workflow.component.InvocableComponent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ScheduledTask
extends InvocableComponent {
    public static final String EXECUTE_SCHEDULED_TASK_METHOD_NAME = "execute";
    private boolean cancelable;

    public ScheduledTask(ScheduledTaskDefinition definition, Method method, Object instance) {
        super(definition, method, instance);
        this.cancelable = definition.isCancelable();
    }

    @Override
    protected Object invokeWithResult(Parameters parameters, Object ... instances) {
        return super.invokeWithResult(parameters, instances);
    }

    @Override
    public void invoke(Parameters parameters, ActivityContextMap activityContextMap, ContextVariables contextVariables) {
        super.invoke(parameters, new Object[0]);
    }

    public boolean isCancelable() {
        return this.cancelable;
    }

    public Map<String, Object> info() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("name", EXECUTE_SCHEDULED_TASK_METHOD_NAME);
        result.put("classname", this.getDeclaringClass().getName());
        result.put("returns", this.getInvocableMethod().getMethod().getReturnType().getSimpleName());
        result.put("annotationName", this.notNull(this.getName()));
        result.put("annotationDesc", this.notNull(this.getDescription()));
        result.put("category", this.notNull(this.getCategoriesAsString()));
        result.put("cancelable", this.isCancelable());
        result.put("isComponent", true);
        result.put("deprecated", this.isDeprecated());
        if (!this.getParameters().isEmpty()) {
            ArrayList params = new ArrayList(this.getParameters().size());
            for (int i = 0; i < this.getParameters().size(); ++i) {
                ParameterDefinition<?> param = this.getParameters().get(i);
                HashMap<String, Object> paramInfo = new HashMap<String, Object>();
                paramInfo.put("position", i);
                paramInfo.put("type", param.getType().javaType().getName());
                paramInfo.put("annotationName", this.notNull(param.getName()));
                paramInfo.put("annotationDesc", this.notNull(param.getDescription()));
                paramInfo.put("fieldType", param.getType().toString());
                paramInfo.put("componentParamId", param.getId());
                paramInfo.put("optional", param.isOptional());
                params.add(paramInfo);
            }
            result.put("params", params);
        } else {
            result.put("params", new LinkedList());
        }
        return result;
    }

    private String notNull(String value) {
        return value == null ? "" : value;
    }

    private String getCategoriesAsString() {
        return StringUtils.join(this.getCategories(), (String)", ");
    }
}

