/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.suncode.pwfl.core.type.TypeBase;
import com.suncode.pwfl.core.type.support.JsonTypeBase;
import org.apache.commons.lang.StringUtils;

public class IntegerType
extends JsonTypeBase<Long> {
    private static final Long defaultValue = 0L;
    public static final IntegerType INSTANCE = new IntegerType();

    private IntegerType() {
        super(Long.class, defaultValue);
        this.aliasType(Integer.class, new TypeBase.Convert<Integer, Long>(){

            @Override
            public Integer fromBase(Long value) {
                return new Integer(value.intValue());
            }

            @Override
            public Long toBase(Integer value) {
                return new Long(value.longValue());
            }
        });
    }

    @Override
    public String name() {
        return "integer";
    }

    @Override
    public String translationKey() {
        return "Calkowity";
    }

    @Override
    protected JsonNode serializeNonNullValue(Long value) {
        return LongNode.valueOf((long)value);
    }

    @Override
    protected Long deserializeNonEmptyNode(JsonNode json) {
        return json.asLong();
    }

    @Override
    public Long convert(String value) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        value = value.replace(" ", "").replace(",", ".");
        return Double.valueOf(value).longValue();
    }
}

