/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.activity;

import com.suncode.pwfl.workflow.assignment.TransferType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="pm_delegatedactivities")
@SequenceGenerator(name="pm_delegatedactivities_id_seq", sequenceName="pm_delegatedactivities_id_seq")
public class DelegatedActivity {
    private Long id;
    private String userId;
    private String activityId;
    private String delegatedUser;
    @Deprecated
    private Boolean inactive;
    private TransferType transferType;

    public DelegatedActivity() {
    }

    public DelegatedActivity(String activityId, String userId, String delegatedUser) {
        this(activityId, userId, delegatedUser, TransferType.SUBSTITUTION);
    }

    public DelegatedActivity(String activityId, String userId, String delegatedUser, boolean inactive) {
        this(activityId, userId, delegatedUser, inactive ? TransferType.DEACTIVATION : TransferType.SUBSTITUTION);
    }

    public DelegatedActivity(String activityId, String userId, String delegatedUser, TransferType transferType) {
        this.activityId = activityId;
        this.userId = userId;
        this.delegatedUser = delegatedUser;
        this.transferType = transferType;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_delegatedactivities_id_seq")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getDelegatedUser() {
        return this.delegatedUser;
    }

    public void setDelegatedUser(String delegatedUser) {
        this.delegatedUser = delegatedUser;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @Deprecated
    public Boolean getInactive() {
        return this.transferType == TransferType.DEACTIVATION;
    }

    @Deprecated
    public void setInactive(Boolean inactive) {
        this.inactive = inactive;
        this.transferType = inactive != false ? TransferType.DEACTIVATION : TransferType.SUBSTITUTION;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(length=20, nullable=false)
    public TransferType getTransferType() {
        return this.transferType;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
        this.inactive = transferType == TransferType.DEACTIVATION;
    }
}

