/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.search.sql;

import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.sql.SQLFilter;
import com.suncode.pwfl.search.sql.SQLQueryBuilder;
import java.sql.Date;
import java.util.Collection;
import java.util.Map;
import org.hibernate.SQLQuery;
import org.joda.time.LocalDate;

public class SimpleSQLFilter
implements SQLFilter {
    private String column;
    private Object value;
    private FilterOperator operator = FilterOperator.EQ;
    private Class<?> type = String.class;
    private String param;
    private String param2;

    public SimpleSQLFilter(String column, Object value, FilterOperator operator, Class<?> type) {
        this.column = column;
        this.value = value;
        this.operator = operator;
        this.type = type;
    }

    public SimpleSQLFilter(String column, Object value, Class<?> type) {
        this.column = column;
        this.value = value;
        this.type = type;
    }

    public SimpleSQLFilter(String column, Object value, FilterOperator operator) {
        this.column = column;
        this.value = value;
        this.operator = operator;
    }

    public SimpleSQLFilter(String column, Object value) {
        this.column = column;
        this.value = value;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public FilterOperator getOperator() {
        return this.operator;
    }

    public void setOperator(FilterOperator operator) {
        this.operator = operator;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    private boolean isList() {
        return this.operator == FilterOperator.IN || this.operator == FilterOperator.NOTIN;
    }

    @Override
    public int buildWhere(StringBuilder query, Integer i) {
        if (this.operator == FilterOperator.ILIKE || this.operator == FilterOperator.NOTILIKE) {
            query.append("LOWER(" + this.getColumn() + ")");
        } else {
            query.append(this.getColumn());
        }
        SQLQueryBuilder.buildOperator(query, this.getOperator());
        if (this.operator == FilterOperator.BETWEEN) {
            query.append(" :");
            this.param = this.getColumn() + "_" + i;
            query.append(this.param);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            query.append("_start and ");
            query.append(" :");
            this.param2 = this.getColumn() + "_" + i;
            query.append(this.param2);
            n = i;
            n2 = i = Integer.valueOf(i + 1);
            query.append("_end ");
        } else if (this.operator != FilterOperator.ISNULL && this.operator != FilterOperator.NOTNULL) {
            if (this.isList()) {
                query.append(" (:");
                this.param = this.getColumn() + "_" + i;
                query.append(this.param);
                Integer n = i;
                Integer n3 = i = Integer.valueOf(i + 1);
                query.append(") ");
            } else if (this.operator == FilterOperator.ILIKE || this.operator == FilterOperator.NOTILIKE) {
                query.append("LOWER(:");
                this.param = this.getColumn() + "_" + i;
                query.append(this.param);
                Integer n = i;
                Integer n4 = i = Integer.valueOf(i + 1);
                query.append(") ");
            } else {
                query.append(" :");
                this.param = this.getColumn() + "_" + i;
                query.append(this.param);
                Integer n = i;
                Integer n5 = i = Integer.valueOf(i + 1);
                query.append(" ");
            }
        }
        return i;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setFilterValue(SQLQuery sql) {
        if (this.operator == FilterOperator.BETWEEN) {
            if (!(this.getValue() instanceof Object[])) throw new IllegalArgumentException("Nieprawid\u0142owy typ warto\u015bci dla filtru o operatorze BETWEEN. Nale\u017cy poda\u0107 dwuelementow\u0105 tablic\u0119 obiekt\u00f3w");
            Object[] vals = (Object[])this.getValue();
            if (vals.length < 2) {
                throw new IllegalArgumentException("Podano za ma\u0142o element\u00f3w tablicy z warto\u015bciami: " + vals.length);
            }
            sql.setParameter(this.param + "_start", vals[0]);
            sql.setParameter(this.param2 + "_end", vals[1]);
            return;
        } else if (this.isList()) {
            if (this.getValue() instanceof Object[]) {
                sql.setParameterList(this.param, (Object[])this.getValue());
                return;
            } else {
                if (!(this.getValue() instanceof Collection)) return;
                sql.setParameterList(this.param, (Collection)this.getValue());
            }
            return;
        } else {
            if (this.operator == FilterOperator.ISNULL || this.operator == FilterOperator.NOTNULL) return;
            if (this.getValue() instanceof LocalDate) {
                sql.setParameter(this.param, (Object)this.convertToJpaFriendlyFormat((LocalDate)this.getValue()));
                return;
            } else {
                sql.setParameter(this.param, this.getValue());
            }
        }
    }

    private Date convertToJpaFriendlyFormat(LocalDate date) {
        return new Date(((LocalDate)this.getValue()).toDateTimeAtStartOfDay().getMillis());
    }

    @Override
    public void setFilterValue(Map<String, Object> params) {
        if (this.operator == FilterOperator.BETWEEN) {
            if (this.getValue() instanceof Object[]) {
                Object[] vals = (Object[])this.getValue();
                if (vals.length < 2) {
                    throw new IllegalArgumentException("Podano za ma\u0142o element\u00f3w tablicy z warto\u015bciami: " + vals.length);
                }
                params.put(this.param + "_start", vals[0]);
                params.put(this.param2 + "_end", vals[1]);
            } else {
                throw new IllegalArgumentException("Nieprawid\u0142owy typ warto\u015bci dla filtru o operatorze BETWEEN. Nale\u017cy poda\u0107 dwuelementow\u0105 tablic\u0119 obiekt\u00f3w");
            }
        }
        params.put(this.param, this.getValue());
    }
}

