/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.component;

import com.google.common.collect.Maps;
import com.suncode.pwfl.component.Argument;
import com.suncode.pwfl.component.ParameterDefinition;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

public class Parameters {
    private final Map<String, Argument> values = Maps.newLinkedHashMap();

    public Parameters(List<Argument> args) {
        Assert.notNull(args, (String)"Args must not be null");
        for (Argument arg : args) {
            this.values.put(arg.getParameter().getId(), arg);
        }
    }

    public boolean exists(String parameterId) {
        return this.values.containsKey(parameterId);
    }

    public <T> T get(String parameterId) {
        return (T)this.getRaw(parameterId).get();
    }

    public <T> T get(String parameterId, Class<T> targetClass) {
        return this.getRaw(parameterId).get(targetClass);
    }

    public Argument getRaw(String parameterId) {
        Argument arg = this.values.get(parameterId);
        if (arg == null) {
            throw new IllegalArgumentException("There is no parameter [" + parameterId + "]");
        }
        return arg;
    }

    public ParameterDefinition<?> getParameter(String parameterId) {
        return this.getRaw(parameterId).getParameter();
    }

    public Map<String, Argument> getRawValues() {
        return this.values;
    }
}

