/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import com.suncode.pwfl.archive.Device;
import com.suncode.pwfl.archive.Directory;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.exception.DeviceNotExistOnDiskException;
import com.suncode.pwfl.archive.exception.DeviceNotFoundException;
import com.suncode.pwfl.archive.exception.NotEnoughSpaceOnDeviceException;
import com.suncode.pwfl.archive.exception.RemovingDeviceWithDirException;
import com.suncode.pwfl.archive.exception.RemovingDirWithDocClassException;
import com.suncode.pwfl.archive.exception.RemovingRootDirectoryException;
import java.util.List;
import org.hibernate.criterion.DetachedCriteria;

public interface ArchiveStorageService {
    public void createDevice(Device var1) throws DeviceNotExistOnDiskException;

    public void createDirectory(Directory var1) throws DeviceNotFoundException, NotEnoughSpaceOnDeviceException;

    public void deleteDevice(String var1) throws RemovingDeviceWithDirException;

    public void deleteDirectory(String var1) throws RemovingRootDirectoryException, RemovingDirWithDocClassException;

    public Device getDevice(String var1, String ... var2);

    public String getDirectoryPath(Directory var1);

    public String resolveDirectoryPath(Directory var1, WfFile var2);

    public boolean isRootDirectory(Directory var1);

    public List<Directory> getChildDirectories(Directory var1);

    public void forceDeleteDeviceByName(String var1);

    public Directory getDirectory(String var1, String ... var2);

    public List<Device> getAllDevices(String ... var1);

    public Device getDeviceById(Long var1, String ... var2);

    public List<Directory> getAllDirectories(String ... var1);

    public void updateDevice(Device var1);

    public void updateDirectory(Directory var1);

    public List<Directory> findDirectoriesByCriteria(DetachedCriteria var1);

    public Directory getDirectory(Long var1, String ... var2);

    public List<Directory> getSubDirectories(Long var1, String ... var2);

    public void deleteDirectory(Long var1);

    public Device getDeviceForDocumentClass(Long var1, String ... var2);

    public Long getDirectoryUsedSpaceFromDB(Directory var1);

    public Long getDirectoryFreeSpaceFromDB(Directory var1);

    public Long getDirectoryUsedSpaceOnDisc(Directory var1);

    public Long getDirectoryFreeSpaceOnDisc(Directory var1);
}

