/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.translation;

import com.suncode.pwfl.translation.NoTranslationException;
import com.suncode.pwfl.translation.Translator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationSupport {
    private static final Logger log = LoggerFactory.getLogger(TranslationSupport.class);

    public static String getMessage(String value, List<Translator> translators) {
        return TranslationSupport.getMessageOrDefault(value, value, translators);
    }

    public static String getMessageOrDefault(String value, String defaultValue, List<Translator> translators) {
        boolean foundTranslation = false;
        String translation = value;
        for (Translator translator : translators) {
            try {
                translation = translator.getMessage(value);
                foundTranslation = true;
                break;
            }
            catch (NoTranslationException ex) {
            }
        }
        if (!foundTranslation) {
            log.debug("No translation for key {}", (Object)value);
            return defaultValue;
        }
        return translation;
    }
}

