/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.translation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.suncode.pwfl.translation.EmptyTranslator;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.TranslatorRegistry;
import com.suncode.pwfl.translation.TranslatorScope;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

public final class Translators {
    private static TranslatorRegistry registry;

    private Translators() {
    }

    static void setupTranslatorRegistry(TranslatorRegistry registry) {
        Assert.state((!Translators.binded() ? 1 : 0) != 0, (String)"TranslatorRegistry already binded");
        Translators.registry = registry;
    }

    private static boolean binded() {
        return registry != null;
    }

    public static List<Translator> getAll(TranslatorScope scope) {
        if (!Translators.binded()) {
            return Lists.newArrayList();
        }
        return registry.getAll(scope);
    }

    public static Map<String, Translator> getAllByName(TranslatorScope scope) {
        if (!Translators.binded()) {
            return Maps.newHashMap();
        }
        return registry.getAllByName(scope);
    }

    public static Translator get(String name) {
        if (!Translators.binded()) {
            return EmptyTranslator.INSTANCE;
        }
        return registry.get(name);
    }

    public static Translator get(String name, TranslatorScope scope) {
        if (!Translators.binded()) {
            return EmptyTranslator.INSTANCE;
        }
        return registry.get(name, scope);
    }

    public static Translator get(Class<?> clazz) {
        if (!Translators.binded()) {
            return EmptyTranslator.INSTANCE;
        }
        return registry.forClass(clazz);
    }
}

