/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.datasource.dao;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.suncode.pwfl.translation.LocalizedString;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.component.declaration.ComponentDeclaration;
import com.suncode.pwfl.workflow.component.declaration.ParameterDeclaration;
import com.suncode.pwfl.workflow.component.declaration.ParameterDeclarationReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;

@Entity(name="pm_datasource")
public class DataSourceDeclaration
extends ComponentDeclaration {
    private String type;
    private String name;
    private String description;
    private byte[] serializedParameters = new byte[0];

    public DataSourceDeclaration(String id, String type, String name, String description, Map<String, ParameterDeclaration> parameters) {
        super(id);
        this.type = type;
        this.name = name;
        this.description = description;
        this.setParameters(parameters);
    }

    @Override
    @Id
    @Column(nullable=false)
    public String getId() {
        return super.getId();
    }

    @Lob
    @JsonIgnore
    @Column(name="parameters")
    private byte[] getSerializedParameters() {
        return this.serializedParameters;
    }

    @Column
    public String getName() {
        return LocalizedString.of(this.name).get();
    }

    @Column
    public String getDescription() {
        return StringUtils.isNotEmpty((CharSequence)this.description) ? LocalizedString.of(this.description).get() : "";
    }

    @Override
    public void setParameters(Map<String, ParameterDeclaration> parameters) {
        try {
            this.serializedParameters = SpringContext.getBean(ParameterDeclarationReader.class).serializeAsBytes(parameters);
            super.setParameters(parameters);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Transient
    public Map<String, ParameterDeclaration> getParameters() {
        try {
            if (super.getParameters() == null || super.getParameters().isEmpty()) {
                super.setParameters(this.serializedParameters.length > 0 ? SpringContext.getBean(ParameterDeclarationReader.class).deserialize(this.serializedParameters) : Collections.emptyMap());
            }
            return super.getParameters();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ParameterDeclaration getParameter(String name) {
        return this.getParameters().get(name);
    }

    public static DataSourceDeclarationBuilder builder() {
        return new DataSourceDeclarationBuilder();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSerializedParameters(byte[] serializedParameters) {
        this.serializedParameters = serializedParameters;
    }

    public String toString() {
        return "DataSourceDeclaration(type=" + this.getType() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", serializedParameters=" + Arrays.toString(this.getSerializedParameters()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSourceDeclaration)) {
            return false;
        }
        DataSourceDeclaration other = (DataSourceDeclaration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        return Arrays.equals(this.getSerializedParameters(), other.getSerializedParameters());
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSourceDeclaration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSerializedParameters());
        return result;
    }

    public DataSourceDeclaration() {
    }

    public static class DataSourceDeclarationBuilder {
        private String id;
        private String type;
        private String name;
        private String description;
        private Map<String, ParameterDeclaration> parameters;

        DataSourceDeclarationBuilder() {
        }

        public DataSourceDeclarationBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DataSourceDeclarationBuilder type(String type) {
            this.type = type;
            return this;
        }

        public DataSourceDeclarationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DataSourceDeclarationBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DataSourceDeclarationBuilder parameters(Map<String, ParameterDeclaration> parameters) {
            this.parameters = parameters;
            return this;
        }

        public DataSourceDeclaration build() {
            return new DataSourceDeclaration(this.id, this.type, this.name, this.description, this.parameters);
        }

        public String toString() {
            return "DataSourceDeclaration.DataSourceDeclarationBuilder(id=" + this.id + ", type=" + this.type + ", name=" + this.name + ", description=" + this.description + ", parameters=" + this.parameters + ")";
        }
    }
}

