/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow;

import com.suncode.pwfl.core.context.Context;
import com.suncode.pwfl.core.function.FunctionContext;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.Exceptions;
import org.enhydra.shark.Shark;
import org.springframework.util.Assert;

public abstract class WorkflowContext
implements Context {
    public static final String NAME = "workflowcontext";
    private final String processId;
    private final String activityId;

    protected WorkflowContext(String processId, String activityId) {
        Assert.hasText((String)processId);
        Assert.hasText((String)activityId);
        this.processId = processId;
        this.activityId = activityId;
    }

    @Override
    public String name() {
        return NAME;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getProcessDefId() {
        return TransactionWrapper.get().doInSharkTransaction(transaction -> Exceptions.sneakyThrows(() -> Shark.getInstance().getAdminInterface().getAdminMisc().getProcessDefinitionId(transaction, this.processId)));
    }

    public String getActivityDefId() {
        return TransactionWrapper.get().doInSharkTransaction(transaction -> Exceptions.sneakyThrows(() -> Shark.getInstance().getAdminInterface().getAdminMisc().getActivityDefinitionId(transaction, this.processId, this.activityId)));
    }

    protected static void activateFunctionContext(String processId, String activityId) {
        if (!FunctionContext.isActive()) {
            FunctionContext.activate(processId, activityId);
        }
    }

    protected static void deactivateFunctionContext() {
        if (FunctionContext.isActive()) {
            FunctionContext.deactivate();
        }
    }
}

