/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.configuration;

import com.plusmpm.security.TextCipher;
import com.suncode.pwfl.administration.configuration.Category;
import com.suncode.pwfl.administration.configuration.ComboValue;
import com.suncode.pwfl.administration.configuration.ParameterType;
import com.suncode.pwfl.administration.configuration.exception.DecryptingException;
import com.suncode.pwfl.administration.configuration.exception.EncryptingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@Entity
@Table(name="pm_systemparameter")
@SequenceGenerator(name="pm_systemparameter_seq", sequenceName="pm_systemparameter_seq")
public class SystemParameter {
    private static Logger log = Logger.getLogger(SystemParameter.class);
    private Long id;
    private String key;
    private Category category;
    private ParameterType parameterType;
    private String valueString;
    private Long valueLong;
    private List<ComboValue> comboValues = new LinkedList<ComboValue>();
    private Boolean valueBool;
    private Date valueDate;
    private Double valueDouble;
    private boolean removable = true;

    public SystemParameter() {
    }

    public SystemParameter(Category category, ParameterType type, String key) {
        this();
        this.category = category;
        this.parameterType = type;
        this.key = key;
        if (type == ParameterType.BOOLEAN) {
            this.valueBool = false;
        }
    }

    public void setValue(Object value) throws RuntimeException {
        switch (this.parameterType) {
            case BOOLEAN: {
                this.valueBool = Boolean.parseBoolean(value.toString());
                break;
            }
            case COMBOBOX: {
                this.valueString = value.toString();
                break;
            }
            case DATE: {
                try {
                    if (value instanceof Date) {
                        this.valueDate = (Date)value;
                        break;
                    }
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    this.valueDate = format.parse(value.toString());
                    break;
                }
                catch (ParseException ex) {
                    log.error((Object)ex);
                    throw new RuntimeException(ex);
                }
            }
            case LONG: {
                this.valueLong = Long.parseLong(value.toString());
                break;
            }
            case DOUBLE: {
                this.valueDouble = Double.parseDouble(value.toString());
                break;
            }
            case TEXT: {
                this.valueString = value.toString();
                break;
            }
            case PASSWORD: {
                if (!StringUtils.isNotEmpty((CharSequence)value.toString())) break;
                try {
                    this.valueString = TextCipher.encrypt(value.toString());
                    break;
                }
                catch (Exception e) {
                    throw new EncryptingException(e);
                }
            }
            default: {
                throw new IllegalArgumentException("Unsupported ParamterType " + (Object)((Object)this.parameterType));
            }
        }
    }

    @Transient
    public Object getValue() {
        switch (this.parameterType) {
            case BOOLEAN: {
                return this.valueBool;
            }
            case COMBOBOX: {
                return this.valueString;
            }
            case DATE: {
                if (this.valueDate != null) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    return format.format(this.valueDate);
                }
                return null;
            }
            case LONG: {
                return this.valueLong;
            }
            case DOUBLE: {
                return this.valueDouble;
            }
            case TEXT: {
                return this.valueString;
            }
            case PASSWORD: {
                if (StringUtils.isNotEmpty((CharSequence)this.valueString)) {
                    try {
                        return TextCipher.decrypt(this.valueString);
                    }
                    catch (Exception e) {
                        throw new DecryptingException(e);
                    }
                }
                return "";
            }
        }
        throw new RuntimeException("Unknow System Parameter type " + (Object)((Object)this.parameterType));
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_systemparameter_seq")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @JoinColumn(name="categoryid", nullable=false)
    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    @Enumerated(value=EnumType.STRING)
    public ParameterType getParameterType() {
        return this.parameterType;
    }

    public void setParameterType(ParameterType parameterType) {
        this.parameterType = parameterType;
    }

    public String getValueString() {
        return this.valueString;
    }

    public void setValueString(String valueString) {
        this.valueString = valueString;
    }

    public Long getValueLong() {
        return this.valueLong;
    }

    public void setValueLong(Long valueLong) {
        this.valueLong = valueLong;
    }

    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="systemParameter")
    public List<ComboValue> getComboValues() {
        return this.comboValues;
    }

    public void setComboValues(List<ComboValue> values) {
        this.comboValues = values;
    }

    public Boolean getValueBool() {
        return this.valueBool;
    }

    public void setValueBool(Boolean valueBool) {
        this.valueBool = valueBool;
    }

    public Date getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(Date valueDate) {
        this.valueDate = valueDate;
    }

    public Double getValueDouble() {
        return this.valueDouble;
    }

    public void setValueDouble(Double valueDouble) {
        this.valueDouble = valueDouble;
    }

    @Column(name="parameterkey")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public void setRemovable(boolean removable) {
        this.removable = removable;
    }

    @Transient
    public Boolean isNull() {
        try {
            return this.getValue() == null;
        }
        catch (DecryptingException ex) {
            log.error((Object)ex);
            return true;
        }
    }
}

