/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class SessionUtils {
    private static RequestAttributes getCurrentRequestAttributes() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            throw new IllegalStateException("Current thread is not bound to HttpRequest");
        }
        return attributes;
    }

    public static HttpServletRequest getCurrentRequest() {
        RequestAttributes requestAttributes = SessionUtils.getCurrentRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            return ((ServletRequestAttributes)requestAttributes).getRequest();
        }
        return null;
    }

    public static HttpSession getCurrentSession() {
        HttpServletRequest request = SessionUtils.getCurrentRequest();
        if (request == null) {
            throw new IllegalStateException("Current thread is not bound to HttpRequest");
        }
        return request.getSession(false);
    }

    public static Object getSessionAttribute(String name) {
        return SessionUtils.getCurrentRequestAttributes().getAttribute(name, 1);
    }

    public static String getLoggedUserName() {
        return (String)SessionUtils.getSessionAttribute("username");
    }

    @Deprecated
    public static String getLoggedUserPassword() {
        return "";
    }
}

