/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.user;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class UserValidator {
    private static final String EMAIL_PATTERN = "^[\\w\\.-]+@([\\w\\-]+\\.)+[\\w]{2,4}$";
    private static final String USER_NAME_PATTERN = "^[a-zA-Z0-9@_\\.\\-\\/]+$";

    public static boolean isUserNameEmpty(String userName) {
        return StringUtils.isBlank((CharSequence)userName);
    }

    public static boolean isUserNameValid(String userName) {
        return userName != null && Pattern.matches(USER_NAME_PATTERN, userName);
    }

    public static boolean isUserFirstNameValid(String firstName) {
        if (StringUtils.isEmpty((CharSequence)firstName)) {
            return true;
        }
        return firstName.length() <= 50;
    }

    public static boolean isUserLastNameValid(String lastName) {
        if (StringUtils.isEmpty((CharSequence)lastName)) {
            return true;
        }
        return lastName.length() <= 50;
    }

    public static boolean doesUserExists(User user) {
        return user != null;
    }

    public static boolean isEmailValid(String userEmail) {
        if (StringUtils.isEmpty((CharSequence)userEmail)) {
            return true;
        }
        return Pattern.matches(EMAIL_PATTERN, userEmail);
    }

    public static boolean hasUserGroup(User user) {
        Set<UserGroup> groups = user.getGroups();
        return CollectionUtils.isNotEmpty(groups);
    }
}

