/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.component;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.suncode.pwfl.component.ComponentDiscovery;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class AnnotatedComponentDiscovery
implements ComponentDiscovery {
    private static final Logger logger = LoggerFactory.getLogger(AnnotatedComponentDiscovery.class);
    private final ResourceLoader resourceLoader;
    private final Class<? extends Annotation>[] annotations;
    private String basePackage;

    public AnnotatedComponentDiscovery(ResourceLoader resourceLoader, Class<? extends Annotation> ... annotations) {
        this.resourceLoader = resourceLoader;
        this.annotations = annotations;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    @Override
    public Set<Class<?>> discoverComponentsClasses() {
        long startedTime = System.currentTimeMillis();
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.setResourceLoader(this.resourceLoader);
        this.addFiltersToScanner(scanner);
        Set definitions = scanner.findCandidateComponents(this.basePackage != null ? this.basePackage : "");
        Set<Class<?>> classes = this.convertToClasses(definitions);
        long elapsedTime = System.currentTimeMillis() - startedTime;
        logger.debug("Discovering components with annotations: [{}] lasted {} [ms]. Found {} candidate components.", new Object[]{this.annotations, elapsedTime, classes.size()});
        return classes;
    }

    private void addFiltersToScanner(ClassPathScanningCandidateComponentProvider scanner) {
        for (Class<? extends Annotation> annotation : this.annotations) {
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotation));
        }
    }

    private Set<Class<?>> convertToClasses(Set<BeanDefinition> definitions) {
        HashSet classes = Sets.newHashSet();
        for (BeanDefinition definition : definitions) {
            String className = definition.getBeanClassName();
            try {
                Class<?> clazz = this.resourceLoader.getClassLoader().loadClass(className);
                this.validateAnnotation(clazz);
                classes.add(clazz);
            }
            catch (Exception e) {
                logger.error("Could not load component '" + className + "'. Skipping.", (Throwable)e);
            }
        }
        return classes;
    }

    private void validateAnnotation(Class<?> clazz) {
        ArrayList foundedAnnotations = Lists.newArrayList();
        for (Class<? extends Annotation> annotation : this.annotations) {
            if (!clazz.isAnnotationPresent(annotation)) continue;
            foundedAnnotations.add(annotation);
        }
    }
}

