/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.configuration;

import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemParameter;
import com.suncode.pwfl.administration.configuration.exception.DecryptingException;
import com.suncode.pwfl.util.ServiceFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;

public class SystemProperties {
    private static final Logger log = Logger.getLogger(SystemProperties.class);

    public static String getString(String key) {
        SystemParameter param = ServiceFactory.getSystemParameterService().getParameter(key);
        if (param != null && param.getValueString() != null) {
            return param.getValueString();
        }
        log.debug((Object)("Not found parameter " + key + " in database or value is null"));
        Properties properties = Shark.getInstance().getProperties();
        if (properties.containsKey(key)) {
            return properties.getProperty(key);
        }
        log.debug((Object)("Not found parameter " + key + " in configuration file"));
        return null;
    }

    public static String getString(String key, String defaultValue) {
        String param = SystemProperties.getString(key);
        if (param == null) {
            return defaultValue;
        }
        return param;
    }

    public static String getString(DefinedSystemParameter definedParameter) {
        return SystemProperties.getString(definedParameter.getKey(), definedParameter.getDefaultValue().toString());
    }

    public static String getPassword(String key) {
        SystemParameter param = ServiceFactory.getSystemParameterService().getParameter(key);
        if (param != null && param.getValueString() != null && SystemProperties.canDecrypt(param).booleanValue()) {
            return param.getValue().toString();
        }
        log.debug((Object)("Not found parameter " + key + " in database or value is null"));
        Properties properties = Shark.getInstance().getProperties();
        if (properties.containsKey(key)) {
            return properties.getProperty(key);
        }
        log.debug((Object)("Not found parameter " + key + " in configuration file"));
        return null;
    }

    private static Boolean canDecrypt(SystemParameter parameter) {
        try {
            parameter.getValue();
            return true;
        }
        catch (DecryptingException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    public static String getPassword(String key, String defaultValue) {
        String param = SystemProperties.getPassword(key);
        if (param == null) {
            return defaultValue;
        }
        return param;
    }

    public static String getPassword(DefinedSystemParameter definedParameter) {
        return SystemProperties.getPassword(definedParameter.getKey(), definedParameter.getDefaultValue().toString());
    }

    public static Boolean getBoolean(String key) {
        SystemParameter param = ServiceFactory.getSystemParameterService().getParameter(key);
        if (param != null && param.getValueBool() != null) {
            return param.getValueBool();
        }
        log.debug((Object)("Not found parameter " + key + " in database or value is null"));
        Properties properties = Shark.getInstance().getProperties();
        if (properties.containsKey(key)) {
            return Boolean.parseBoolean(properties.getProperty(key));
        }
        log.debug((Object)("Not found parameter " + key + " in configuration file"));
        return null;
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        Boolean param = SystemProperties.getBoolean(key);
        if (param == null) {
            return defaultValue;
        }
        return param;
    }

    public static Boolean getBoolean(DefinedSystemParameter definedParameter) {
        return SystemProperties.getBoolean(definedParameter.getKey(), (Boolean)definedParameter.getDefaultValue());
    }

    public static Long getLong(String key) {
        SystemParameter param = ServiceFactory.getSystemParameterService().getParameter(key);
        if (param != null && param.getValueLong() != null) {
            return param.getValueLong();
        }
        log.debug((Object)("Not found parameter " + key + " in database or value is null"));
        Properties properties = Shark.getInstance().getProperties();
        if (properties.containsKey(key)) {
            return Long.parseLong(properties.getProperty(key));
        }
        log.debug((Object)("Not found parameter " + key + " in configuration file"));
        return null;
    }

    public static Long getLong(String key, Long defaultValue) {
        Long param = SystemProperties.getLong(key);
        if (param == null) {
            return defaultValue;
        }
        return param;
    }

    public static Long getLong(DefinedSystemParameter definedParameter) {
        return SystemProperties.getLong(definedParameter.getKey(), (Long)definedParameter.getDefaultValue());
    }

    public static Double getDouble(String key) {
        SystemParameter param = ServiceFactory.getSystemParameterService().getParameter(key);
        if (param != null && param.getValueDouble() != null) {
            return param.getValueDouble();
        }
        log.debug((Object)("Not found parameter " + key + " in database or value is null"));
        Properties properties = Shark.getInstance().getProperties();
        if (properties.containsKey(key)) {
            return Double.parseDouble(properties.getProperty(key));
        }
        log.debug((Object)("Not found parameter " + key + " in configuration file"));
        return null;
    }

    public static Double getDouble(String key, Double defaultValue) {
        Double param = SystemProperties.getDouble(key);
        if (param == null) {
            return defaultValue;
        }
        return param;
    }

    public static Double getDouble(DefinedSystemParameter definedParameter) {
        return SystemProperties.getDouble(definedParameter.getKey(), (Double)definedParameter.getDefaultValue());
    }

    public static Date getDate(String key) {
        SystemParameter param = ServiceFactory.getSystemParameterService().getParameter(key);
        if (param != null && param.getValueDate() != null) {
            return param.getValueDate();
        }
        log.debug((Object)("Not found parameter " + key + " in database or value is null"));
        Properties properties = Shark.getInstance().getProperties();
        if (properties.containsKey(key)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            try {
                return format.parse(properties.getProperty(key));
            }
            catch (ParseException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                return null;
            }
        }
        log.debug((Object)("Not found parameter " + key + " in configuration file"));
        return null;
    }

    public static Date getDate(String key, Date defaultValue) {
        Date param = SystemProperties.getDate(key);
        if (param == null) {
            return defaultValue;
        }
        return param;
    }

    public static Date getDate(DefinedSystemParameter definedParameter) {
        return SystemProperties.getDate(definedParameter.getKey(), (Date)definedParameter.getDefaultValue());
    }
}

