/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.suncode.pwfl.core.type.support.JsonTypeBase;
import org.apache.commons.lang.StringUtils;

public class BooleanType
extends JsonTypeBase<Boolean> {
    public static final BooleanType INSTANCE = new BooleanType();

    private BooleanType() {
        super(Boolean.class);
    }

    @Override
    public String name() {
        return "boolean";
    }

    @Override
    public String translationKey() {
        return "Logiczny";
    }

    @Override
    protected JsonNode serializeNonNullValue(Boolean value) {
        return BooleanNode.valueOf((boolean)value);
    }

    @Override
    protected Boolean deserializeNonEmptyNode(JsonNode json) {
        return json.asBoolean();
    }

    @Override
    public Boolean convert(String value) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        return Boolean.parseBoolean(value);
    }
}

