/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.form.datachooser;

import com.google.common.collect.Lists;
import com.suncode.pwfl.component.ComponentDefinition;
import com.suncode.pwfl.component.ComponentDefinitionBuilder;
import com.suncode.pwfl.component.exception.InvalidComponentException;
import com.suncode.pwfl.translation.EmptyTranslator;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserDefinition;
import com.suncode.pwfl.workflow.form.datachooser.Mapping;
import com.suncode.pwfl.workflow.form.datachooser.MappingDefinitionBuilder;
import java.util.List;

public class DataChooserDefinitionBuilder
extends ComponentDefinitionBuilder<DataChooserDefinitionBuilder> {
    private List<Mapping> mappings = Lists.newArrayList();
    private boolean customMappingsEnabled = false;
    private boolean hasSelfMapping = false;

    public DataChooserDefinitionBuilder() {
        this(EmptyTranslator.INSTANCE);
    }

    public DataChooserDefinitionBuilder(Translator translator) {
        super(translator);
    }

    public MappingDefinitionBuilder mapping() {
        return new MappingDefinitionBuilder(this);
    }

    protected DataChooserDefinitionBuilder mapping(Mapping mapping) {
        if (mapping.isSelf()) {
            if (this.hasSelfMapping) {
                throw new InvalidComponentException("Datachooser must have only one self mapping.");
            }
            this.hasSelfMapping = true;
            this.mappings.add(0, mapping);
        } else {
            this.mappings.add(mapping);
        }
        return this;
    }

    public DataChooserDefinitionBuilder enableCustomMappings() {
        this.customMappingsEnabled = true;
        return this;
    }

    @Override
    public ComponentDefinition create() {
        this.addSelfMappingIfNecessary();
        return new DataChooserDefinition(this.id, this.documentationLink, this.name, this.description, this.icon, this.categories, this.parameters, this.mappings, this.customMappingsEnabled, this.contextVariables);
    }

    private void addSelfMappingIfNecessary() {
        if (!this.customMappingsEnabled && !this.hasSelfMapping) {
            this.mapping().id("value").self().create();
        }
    }

    @Override
    protected DataChooserDefinitionBuilder getThis() {
        return this;
    }
}

