/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.type.support;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.suncode.pwfl.core.type.TypeBase;
import com.suncode.pwfl.core.type.support.JsonSerializable;

public abstract class JsonTypeBase<T>
extends TypeBase<T>
implements JsonSerializable<T> {
    public JsonTypeBase(Class<T> javaType) {
        super(javaType);
    }

    @Override
    public JsonNode serializeJson(T value) {
        if (this.isValueEmpty(value)) {
            return this.emptyNode();
        }
        return this.serializeNonNullValue(value);
    }

    @Override
    public T deserializeJson(JsonNode json) {
        if (this.isNodeEmpty(json)) {
            return this.emptyValue();
        }
        return this.deserializeNonEmptyNode(json);
    }

    public abstract String translationKey();

    protected abstract JsonNode serializeNonNullValue(T var1);

    protected abstract T deserializeNonEmptyNode(JsonNode var1);

    protected T emptyValue() {
        return null;
    }

    protected JsonNode emptyNode() {
        return NullNode.instance;
    }

    protected boolean isValueEmpty(T value) {
        return value == null;
    }

    protected boolean isNodeEmpty(JsonNode json) {
        return json == null || json.isNull() || json.isTextual() && json.asText().isEmpty();
    }
}

