/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.type;

import com.google.common.collect.Maps;
import com.suncode.pwfl.core.type.Type;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class TypeBase<T>
implements Type<T> {
    protected static final Class<?>[] NO_ALIASES = new Class[0];
    private final Class<T> javaType;
    private final Map<Class<?>, Convert<?, T>> converters = Maps.newHashMap();
    private boolean forceInstanceWhenReading = true;

    public TypeBase(Class<T> javaType) {
        Assert.notNull(javaType);
        this.javaType = javaType;
    }

    protected void setForceInstanceWhenReading(boolean forceInstanceWhenReading) {
        this.forceInstanceWhenReading = forceInstanceWhenReading;
    }

    protected boolean isForceInstanceWhenReading() {
        return this.forceInstanceWhenReading;
    }

    @Override
    public Class<T> javaType() {
        return this.javaType;
    }

    @Override
    public boolean isInstance(Object value) {
        return value == null || this.isInstance(value.getClass());
    }

    protected <S> void aliasType(Class<S> type, Convert<S, T> aliased) {
        this.converters.put(type, aliased);
    }

    @Override
    public boolean isInstance(Class<?> type) {
        if (type == null) {
            return false;
        }
        if (this.isAssignable(type, this.javaType)) {
            return true;
        }
        for (Class<?> alias : this.converters.keySet()) {
            if (!this.isAssignable(type, alias)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAssignable(Class<?> source, Class<?> target) {
        return this.resolve(target).isAssignableFrom(this.resolve(source));
    }

    @Override
    public T read(Object value) {
        return this.readAs(value, this.javaType);
    }

    @Override
    public <I, O> O readAs(I value, Class<O> type) {
        if (value == null) {
            return null;
        }
        if (!(!this.forceInstanceWhenReading || this.isInstance(value) && this.isInstance(type))) {
            throw new IllegalArgumentException("Object [" + value + "] or/and target type [" + type + "] is not instance of [" + this + "]");
        }
        Class<?> in = this.resolve(value.getClass());
        Class<O> out = this.resolve(type);
        if (out.isAssignableFrom(in)) {
            return (O)value;
        }
        return this.doReadAs(value, in, out);
    }

    protected <I, O> O doReadAs(I value, Class<I> in, Class<O> out) {
        Convert<?, T> source = this.converters.get(in);
        Convert<?, Object> target = this.converters.get(out);
        if (this.javaType.isAssignableFrom(out)) {
            return (O)source.toBase(value);
        }
        if (this.javaType.isAssignableFrom(in)) {
            return (O)target.fromBase(value);
        }
        return (O)target.fromBase(source.toBase(value));
    }

    private Class<?> resolve(Class<?> clazz) {
        return ClassUtils.resolvePrimitiveIfNecessary(clazz);
    }

    public String toString() {
        return this.name();
    }

    @Override
    public abstract T convert(String var1);

    public static interface Convert<A, T> {
        public A fromBase(T var1);

        public T toBase(A var1);
    }
}

