/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.form.validator;

import com.suncode.pwfl.component.ComponentDefinition;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.component.ContextVariables;
import com.suncode.pwfl.workflow.component.InvocableComponent;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.error.ValidationError;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator
extends InvocableComponent {
    public static final String VALIDATE_METHOD_NAME = "validate";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Validator(ComponentDefinition definition, Method validateMethod, Object instance) {
        super(definition, validateMethod, instance);
    }

    @Override
    public void invoke(Parameters parameters, ActivityContextMap contextMap, ContextVariables contextVariables) {
        ValidationContext context = ValidationContext.current();
        this.logger.debug("Evaluating validator [{}]", (Object)this);
        super.invoke(parameters, context, context.getValidationErrors(), contextMap, contextVariables);
        this.logErrors(context.getValidationErrors().getErrors(this.getId()));
    }

    private void logErrors(List<ValidationError> errors) {
        if (CollectionUtils.isEmpty(errors)) {
            this.logger.debug("Validator[{}] does not report any errors.", (Object)this.getId());
        }
        StringBuilder sb = new StringBuilder();
        for (ValidationError error : errors) {
            sb.append("[").append(error.getMessage()).append("] ");
        }
        this.logger.debug("Validator[{}] reports {} errors: {}", new Object[]{this.getId(), errors.size(), sb.toString()});
    }
}

