/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.component.support;

import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.component.support.InvocableMethod;
import com.suncode.pwfl.component.support.ParameterBinder;
import org.springframework.util.Assert;

public class ParametersBinder
implements ParameterBinder {
    private final Parameters parameters;
    private boolean requireParamAnnotation = true;

    public ParametersBinder(Parameters parameters) {
        this(parameters, true);
    }

    public ParametersBinder(Parameters parameters, boolean requireParamAnnotation) {
        Assert.notNull((Object)parameters);
        this.parameters = parameters;
        this.requireParamAnnotation = requireParamAnnotation;
    }

    @Override
    public boolean shouldBind(int index, Class<?> type, InvocableMethod method) {
        String paramName = method.getParameterName(index);
        boolean paramPresent = this.parameters.exists(paramName);
        if (method.hasParameterAnnotation(index, Param.class)) {
            if (!paramPresent) {
                throw new IllegalArgumentException("Parameter [" + paramName + "] does not exists!");
            }
            return true;
        }
        return !this.requireParamAnnotation && paramPresent;
    }

    @Override
    public Object bind(int index, Class<?> type, InvocableMethod method) {
        return this.parameters.get(method.getParameterName(index), type);
    }
}

