/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import org.apache.commons.lang.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public enum IndexType {
    STRING("string"){

        @Override
        public Object parse(String value) {
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            return value;
        }
    }
    ,
    LONG("integer"){

        @Override
        public Object parse(String value) {
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            return Long.valueOf(value);
        }
    }
    ,
    LIST("list"){

        @Override
        public Object parse(String value) {
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            return value;
        }
    }
    ,
    DATE("date"){

        @Override
        public Object parse(String value) {
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            return new LocalDate((Object)value);
        }
    }
    ,
    DATETIME("dateTime"){

        @Override
        public Object parse(String value) {
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            return new LocalDateTime((Object)value);
        }
    }
    ,
    DOUBLE("float"){

        @Override
        public Object parse(String value) {
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            return Double.valueOf(value);
        }
    };

    private String value;

    private IndexType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static IndexType getType(String name) {
        for (IndexType indexType : IndexType.values()) {
            if (!indexType.value.equals(name)) continue;
            return indexType;
        }
        throw new RuntimeException("No such type value: " + name);
    }

    public abstract Object parse(String var1);
}

