/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.form.validator.error;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.suncode.pwfl.workflow.form.validator.error.Confirmation;
import com.suncode.pwfl.workflow.form.validator.error.ValidationError;
import com.suncode.pwfl.workflow.form.validator.error.VariableSetVariableValidationError;
import com.suncode.pwfl.workflow.form.validator.error.VariableValidationError;
import java.util.Collection;
import java.util.List;

public class ValidationErrors {
    private final Multimap<String, ValidationError> errors = HashMultimap.create();
    private final List<Confirmation> confirmations = Lists.newArrayList();
    private String currentValidator = null;

    public void setCurrentValidator(String currentValidator) {
        this.currentValidator = currentValidator;
    }

    public void removeCurrentValidator() {
        this.currentValidator = null;
    }

    public void add(String error) {
        this.errors.put((Object)this.currentValidator, (Object)new ValidationError(error));
    }

    public void add(String error, String variableId) {
        this.errors.put((Object)this.currentValidator, (Object)new VariableValidationError(variableId, error));
    }

    public void add(String error, String variableId, int rowIndex) {
        this.errors.put((Object)this.currentValidator, (Object)new VariableSetVariableValidationError(variableId, rowIndex, error));
    }

    public void addConfirmation(String message, String title) {
        this.addConfirmation(new Confirmation(message, title));
    }

    public void addConfirmation(Confirmation confirmation) {
        this.confirmations.add(confirmation);
    }

    public List<ValidationError> getErrors() {
        return ImmutableList.copyOf((Collection)this.errors.values());
    }

    public List<ValidationError> getErrors(String validatorId) {
        return ImmutableList.copyOf((Collection)this.errors.get((Object)validatorId));
    }

    public List<Confirmation> getConfirmations() {
        return ImmutableList.copyOf(this.confirmations);
    }

    public boolean areEmpty() {
        return this.errors.isEmpty();
    }
}

