/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.user;

import com.suncode.pwfl.administration.user.DeactivationActivity;
import com.suncode.pwfl.administration.user.DeactivationParticipant;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.workflow.process.ProcessType;
import java.util.List;

public class DeactivationProcess {
    private String name;
    private String description;
    private String packageId;
    private String processDefId;
    private List<DeactivationParticipant> participants;

    protected DeactivationProcess(ProcessType processType) {
        this.name = processType.getName();
        this.processDefId = processType.getProcessDefId();
        this.description = processType.getDescription();
        this.packageId = processType.getPackageId();
    }

    public DeactivationProcess(String name, String processDefId, String description, String packageId, List<DeactivationParticipant> participants) {
        this.name = name;
        this.processDefId = processDefId;
        this.description = description;
        this.packageId = packageId;
        this.participants = participants;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public String getProcessDefId() {
        return this.processDefId;
    }

    public List<DeactivationParticipant> getParticipants() {
        return this.participants;
    }

    protected void setParticipants(List<DeactivationParticipant> participants) {
        this.participants = participants;
    }

    public void setUsers(List<User> users) {
        for (DeactivationParticipant participant : this.participants) {
            List<DeactivationActivity> activities = participant.getActivities();
            for (DeactivationActivity activity : activities) {
                activity.setUsers(users);
            }
        }
    }

    public void setGroups(List<UserGroup> groups) {
        for (DeactivationParticipant participant : this.participants) {
            List<DeactivationActivity> activities = participant.getActivities();
            for (DeactivationActivity activity : activities) {
                activity.setGroups(groups);
            }
        }
    }

    public static DeactivationProcess find(DeactivationProcess processToFind, List<DeactivationProcess> processList) {
        for (DeactivationProcess process : processList) {
            if (!process.equals(processToFind)) continue;
            return processToFind;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeactivationProcess)) {
            return false;
        }
        DeactivationProcess proc2 = (DeactivationProcess)obj;
        return this.getProcessDefId().equals(proc2.getProcessDefId()) && this.getPackageId().equals(proc2.getPackageId());
    }
}

