/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.util;

import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.RoleFinder;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserGroupFinder;
import com.suncode.pwfl.archive.DocumentClassActionFinder;
import com.suncode.pwfl.archive.DocumentClassIndexFinder;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.FileFinder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.transaction.SharkTransactionManager;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.process.ProcessFinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class FinderFactory {
    private static ApplicationContext ctx;

    @Autowired
    public void setContext(ApplicationContext ctx) {
        FinderFactory.ctx = ctx;
    }

    public static UserFinder getUserFinder() {
        return (UserFinder)ctx.getBean(UserFinder.class);
    }

    public static UserGroupFinder getUserGroupFinder() {
        return (UserGroupFinder)ctx.getBean(UserGroupFinder.class);
    }

    public static DocumentFinder getDocumentFinder() {
        SharkTransactionManager tm = TransactionManagerFactory.getSharkTransactionManager();
        if (tm.isSharkTransactionActive()) {
            return (DocumentFinder)ctx.getBean("sharkDocumentFinder");
        }
        return (DocumentFinder)ctx.getBean("documentFinder");
    }

    public static FileFinder getFileFinder() {
        return (FileFinder)ctx.getBean(FileFinder.class);
    }

    public static ProcessFinder getProcessFinder() {
        return (ProcessFinder)ctx.getBean(ProcessFinder.class);
    }

    public static ActivityFinder getActivityFinder() {
        SharkTransactionManager tm = TransactionManagerFactory.getSharkTransactionManager();
        if (tm.isSharkTransactionActive()) {
            return (ActivityFinder)ctx.getBean("sharkActivityFinder");
        }
        return (ActivityFinder)ctx.getBean("activityFinder");
    }

    public static PositionFinder getPositionFinder() {
        return (PositionFinder)ctx.getBean(PositionFinder.class);
    }

    public static OrganizationalUnitFinder getOrganizationalUnitFinder() {
        return (OrganizationalUnitFinder)ctx.getBean(OrganizationalUnitFinder.class);
    }

    public static DocumentClassActionFinder getDocumentClassActionFinder() {
        return (DocumentClassActionFinder)ctx.getBean(DocumentClassActionFinder.class);
    }

    public static DocumentClassIndexFinder getDocumentClassIndexFinder() {
        return (DocumentClassIndexFinder)ctx.getBean(DocumentClassIndexFinder.class);
    }

    public static SQLFinder getSQLFinder() {
        return (SQLFinder)ctx.getBean(SQLFinder.class);
    }

    public static RoleFinder getRoleFinder() {
        return (RoleFinder)ctx.getBean(RoleFinder.class);
    }
}

