/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.util.logging;

import com.suncode.pwfl.util.logging.LoggerLevel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.springframework.util.Assert;

public class LoggerOutputStream
extends OutputStream {
    private Logger logger;
    private LoggerLevel level;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public LoggerOutputStream(Logger logger) {
        this(logger, LoggerLevel.DEBUG);
    }

    public LoggerOutputStream(Logger logger, LoggerLevel level) {
        Assert.notNull((Object)logger, (String)"Logger must not be null");
        Assert.notNull((Object)((Object)level), (String)"Logger level must not be null");
        this.logger = logger;
        this.level = level;
    }

    @Override
    public void write(int b) throws IOException {
        char c = (char)b;
        if (c == '\n' || c == '\r') {
            this.writeBuffer();
        } else {
            this.buffer.write(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBuffer() {
        try {
            if (this.buffer.size() > 0) {
                this.level.log(this.logger, this.buffer.toString(), new Object[0]);
            }
        }
        finally {
            this.buffer.reset();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.buffer.size() > 0) {
            this.writeBuffer();
        }
        super.close();
    }
}

