/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.user;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.core.context.Context;
import com.suncode.pwfl.core.context.ContextHolder;
import com.suncode.pwfl.core.context.ContextNotActiveException;
import com.suncode.pwfl.core.context.InContext;
import org.springframework.util.Assert;

public class UserContext
implements Context {
    public static final String NAME = "usercontext";
    private static final ContextHolder<UserContext> holder = new ContextHolder("usercontext");
    private static final ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private final UserInfo user;

    private UserContext(UserInfo user) {
        Assert.notNull((Object)user);
        this.user = user;
    }

    @Override
    public String name() {
        return NAME;
    }

    public UserInfo getUser() {
        return this.user;
    }

    public String getUserJson() {
        try {
            return mapper.writeValueAsString((Object)this.user);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Unexprected error during json serialization", e);
        }
    }

    public static boolean isActive() {
        return holder.isActive();
    }

    public static UserContext current() throws ContextNotActiveException {
        return holder.current();
    }

    public static UserContext activate(UserInfo user) {
        UserContext context = new UserContext(user);
        holder.activate(context);
        return context;
    }

    public static void activate(UserInfo user, InContext<UserContext> action) {
        holder.activate(new UserContext(user), action);
    }

    public static UserContext deactivate() {
        return holder.remove();
    }
}

