/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.form.action;

import com.suncode.pwfl.workflow.form.action.ActionTarget;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.springframework.util.Assert;

public class ActionDestination {
    private final Type type;
    private String bindTo;

    private ActionDestination(Type type) {
        this(type, null);
    }

    private ActionDestination(Type type, String bindTo) {
        Assert.notNull((Object)((Object)type));
        this.type = type;
        this.bindTo = bindTo;
    }

    public Type getType() {
        return this.type;
    }

    public String getBindTo() {
        return this.bindTo;
    }

    public void setBindTo(String bindTo) {
        this.bindTo = bindTo;
    }

    public boolean matchesTarget(ActionTarget target) {
        return this.type.equals((Object)target.getType());
    }

    public static ActionDestination form() {
        return new ActionDestination(Type.FORM);
    }

    public static ActionDestination variable() {
        return new ActionDestination(Type.VARIABLE);
    }

    public static ActionDestination variable(String bindTo) {
        return new ActionDestination(Type.VARIABLE, bindTo);
    }

    public static ActionDestination variableSet() {
        return new ActionDestination(Type.VARIABLESET);
    }

    public static ActionDestination variableSet(String bindTo) {
        return new ActionDestination(Type.VARIABLESET, bindTo);
    }

    public static ActionDestination button() {
        return new ActionDestination(Type.BUTTON);
    }

    public static ActionDestination button(String bindTo) {
        return new ActionDestination(Type.BUTTON, bindTo);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ActionDestination) {
            ActionDestination other = (ActionDestination)obj;
            return new EqualsBuilder().append((Object)this.type, (Object)other.type).append((Object)this.bindTo, (Object)other.bindTo).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.type).append((Object)this.bindTo).toHashCode();
    }

    public static enum Type {
        FORM,
        VARIABLE,
        VARIABLESET,
        BUTTON;


        public static Type forType(String type) {
            return Type.valueOf(type.toUpperCase());
        }
    }
}

