/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.database;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceFactory {
    private static DataSource dataSource;
    private static final Logger log;

    private static DataSource getDataSourceFromContext() throws NamingException {
        InitialContext initialContext = new InitialContext();
        return (DataSource)initialContext.lookup("java:comp/env/PlusWorkflowResource");
    }

    public static DataSource getDataSource() {
        return dataSource;
    }

    static {
        log = LoggerFactory.getLogger(DataSourceFactory.class);
        try {
            dataSource = DataSourceFactory.getDataSourceFromContext();
        }
        catch (NamingException e) {
            log.error("Cannot initialize plusworkflow data source.", (Throwable)e);
        }
    }
}

