/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.component;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.ParameterDefinition;
import com.suncode.pwfl.component.exception.UnknownParameterException;
import com.suncode.pwfl.translation.LocalizedString;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.component.ContextVariable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ComponentDefinition {
    private final String id;
    private final LocalizedString name;
    private final LocalizedString description;
    private final Icon icon;
    private final List<Category> categories;
    private final List<ContextVariable<?>> contextVariables;
    private final Map<String, ParameterDefinition<?>> parameters;

    public ComponentDefinition(ComponentDefinition definition) {
        this(definition.getId(), definition.name, definition.description, definition.getIcon(), definition.getCategories(), definition.getParameters(), definition.getContextVariables());
    }

    public ComponentDefinition(String id, LocalizedString name, LocalizedString description, Icon icon, List<Category> categories, List<ParameterDefinition<?>> parameters, List<ContextVariable<?>> contextVariables) {
        Assert.hasText((String)id);
        Assert.notNull((Object)name);
        this.id = id;
        this.name = name;
        this.description = description;
        this.icon = icon;
        this.categories = ImmutableList.copyOf((Collection)(categories != null ? categories : Lists.newArrayList()));
        this.contextVariables = ImmutableList.copyOf((Collection)(contextVariables != null ? contextVariables : Lists.newArrayList()));
        LinkedHashMap parametersMap = Maps.newLinkedHashMap();
        if (!CollectionUtils.isEmpty(parameters)) {
            for (ParameterDefinition<?> parameter : parameters) {
                parametersMap.put(parameter.getId(), parameter);
            }
        }
        this.parameters = ImmutableMap.copyOf((Map)parametersMap);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name.getOptional();
    }

    public String getDescription() {
        return this.description != null ? this.description.getOptional() : null;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public List<ContextVariable<?>> getContextVariables() {
        return this.contextVariables;
    }

    public List<ParameterDefinition<?>> getParameters() {
        return ImmutableList.copyOf(this.parameters.values());
    }

    public ParameterDefinition<?> getParameter(String id) throws UnknownParameterException {
        ParameterDefinition<?> parameter = this.parameters.get(id);
        if (parameter != null) {
            return parameter;
        }
        throw new UnknownParameterException(this, id);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ComponentDefinition) {
            ComponentDefinition other = (ComponentDefinition)obj;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).append((Object)this.name, (Object)other.name).append((Object)this.description, (Object)other.description).append(this.categories, other.categories).append(this.parameters, other.parameters).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.name).append((Object)this.description).append(this.categories).append(this.parameters).toHashCode();
    }
}

