/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.form.datachooser;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.ComponentDefinition;
import com.suncode.pwfl.component.ParameterDefinition;
import com.suncode.pwfl.component.exception.UnknownParameterException;
import com.suncode.pwfl.translation.LocalizedString;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.component.ContextVariable;
import com.suncode.pwfl.workflow.form.datachooser.Mapping;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.springframework.util.CollectionUtils;

public class DataChooserDefinition
extends ComponentDefinition {
    private final Map<String, Mapping> mappings;

    public DataChooserDefinition(String id, LocalizedString name, LocalizedString description, Icon icon, List<Category> categories, List<ParameterDefinition<?>> parameters, List<Mapping> mappings, List<ContextVariable<?>> contextVariables) {
        super(id, name, description, icon, categories, parameters, contextVariables);
        LinkedHashMap mappingsMap = Maps.newLinkedHashMap();
        if (!CollectionUtils.isEmpty(mappings)) {
            for (Mapping mapping : mappings) {
                mappingsMap.put(mapping.getId(), mapping);
            }
        }
        this.mappings = ImmutableMap.copyOf((Map)mappingsMap);
    }

    public Map<String, Mapping> getMappings() {
        return this.mappings;
    }

    public Mapping getMapping(String id) throws UnknownParameterException {
        Mapping mapping = this.mappings.get(id);
        if (mapping != null) {
            return mapping;
        }
        throw new UnknownParameterException(this, id);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof DataChooserDefinition) {
            DataChooserDefinition other = (DataChooserDefinition)obj;
            return new EqualsBuilder().appendSuper(super.equals(other)).append(this.mappings, other.mappings).isEquals();
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.mappings).toHashCode();
    }
}

